/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.phoenix.end2end.TlsUtil;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.ThinClientUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServerEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(QueryServerEnvironment.class);
    private final File TEMP_DIR = new File(QueryServerEnvironment.getTempDir());
    private final File KEYTAB_DIR = new File(this.TEMP_DIR, "keytabs");
    private final List<File> USER_KEYTAB_FILES = new ArrayList<File>();
    private static final String LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
    static final String LOGIN_USER;
    private static final String SPNEGO_PRINCIPAL;
    private static final String PQS_PRINCIPAL;
    private static final String SERVICE_PRINCIPAL;
    private File KEYTAB;
    private MiniKdc KDC;
    private HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private LocalHBaseCluster HBASE_CLUSTER;
    private int NUM_CREATED_USERS;
    private ExecutorService PQS_EXECUTOR;
    private QueryServer PQS;
    private int PQS_PORT;
    private String PQS_URL;
    private boolean tls;

    private static String getTempDir() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(System.getProperty("user.dir")).append(File.separator);
        sb.append("target").append(File.separator);
        sb.append(QueryServerEnvironment.class.getSimpleName());
        sb.append("-").append(UUID.randomUUID());
        return sb.toString();
    }

    public int getPqsPort() {
        return this.PQS_PORT;
    }

    public String getPqsUrl() {
        return this.PQS_URL;
    }

    public boolean getTls() {
        return this.tls;
    }

    public HBaseTestingUtility getUtil() {
        return this.UTIL;
    }

    public String getServicePrincipal() {
        return SERVICE_PRINCIPAL;
    }

    public File getServiceKeytab() {
        return this.KEYTAB;
    }

    private static void updateDefaultRealm() throws Exception {
        Field f = KerberosName.class.getDeclaredField("defaultRealm");
        f.setAccessible(true);
        f.set(null, "EXAMPLE.COM");
    }

    private void createUsers(int numUsers) throws Exception {
        Assert.assertNotNull((String)"KDC is null, was setup method called?", (Object)this.KDC);
        this.NUM_CREATED_USERS = numUsers;
        for (int i = 1; i <= numUsers; ++i) {
            String principal = "user" + i;
            File keytabFile = new File(this.KEYTAB_DIR, principal + ".keytab");
            this.KDC.createPrincipal(keytabFile, new String[]{principal});
            this.USER_KEYTAB_FILES.add(keytabFile);
        }
    }

    public Map.Entry<String, File> getUser(int offset) {
        if (offset <= 0 || offset > this.NUM_CREATED_USERS) {
            throw new IllegalArgumentException();
        }
        return new AbstractMap.SimpleImmutableEntry<String, File>("user" + offset, this.USER_KEYTAB_FILES.get(offset - 1));
    }

    private void setHdfsSecuredConfiguration(Configuration conf) throws Exception {
        conf.set("dfs.namenode.kerberos.principal", SERVICE_PRINCIPAL + "@" + this.KDC.getRealm());
        conf.set("dfs.namenode.keytab.file", this.KEYTAB.getAbsolutePath());
        conf.set("dfs.datanode.kerberos.principal", SERVICE_PRINCIPAL + "@" + this.KDC.getRealm());
        conf.set("dfs.datanode.keytab.file", this.KEYTAB.getAbsolutePath());
        conf.set("dfs.web.authentication.kerberos.principal", SPNEGO_PRINCIPAL + "@" + this.KDC.getRealm());
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(this.UTIL.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        String sslConfDir = TlsUtil.getClasspathDir(QueryServerEnvironment.class);
        TlsUtil.setupSSLConfig((String)keystoresDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.setBoolean("ignore.secure.ports.for.testing", true);
    }

    private static void ensureIsEmptyDirectory(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
            } else {
                Assert.assertTrue((String)"Failed to delete keytab directory", (boolean)f.delete());
            }
        }
        Assert.assertTrue((String)"Failed to create keytab directory", (boolean)f.mkdirs());
    }

    public QueryServerEnvironment(Configuration confIn, int numberOfUsers, boolean tls) throws Exception {
        this.tls = tls;
        final Configuration conf = this.UTIL.getConfiguration();
        conf.addResource(confIn);
        QueryServerEnvironment.ensureIsEmptyDirectory(this.TEMP_DIR);
        QueryServerEnvironment.ensureIsEmptyDirectory(this.KEYTAB_DIR);
        this.KEYTAB = new File(this.KEYTAB_DIR, "test.keytab");
        this.KDC = this.UTIL.setupMiniKdc(this.KEYTAB);
        this.KDC.createPrincipal(this.KEYTAB, new String[]{SPNEGO_PRINCIPAL, PQS_PRINCIPAL, SERVICE_PRINCIPAL});
        this.UTIL.startMiniZKCluster();
        this.createUsers(numberOfUsers);
        HBaseKerberosUtils.setPrincipalForTesting((String)(SERVICE_PRINCIPAL + "@" + this.KDC.getRealm()));
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf);
        this.setHdfsSecuredConfiguration(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        conf.setInt("hbase.master.port", 0);
        conf.setInt("hbase.master.info.port", 0);
        conf.setInt("hbase.regionserver.port", 0);
        conf.setInt("hbase.regionserver.info.port", 0);
        if (tls) {
            conf.setBoolean("phoenix.queryserver.tls.enabled", true);
            conf.set("phoenix.queryserver.tls.keystore", TlsUtil.getKeyStoreFile().getAbsolutePath());
            conf.set("phoenix.queryserver.tls.keystore.password", TlsUtil.getKeyStorePassword());
            conf.set("phoenix.queryserver.tls.truststore", TlsUtil.getTrustStoreFile().getAbsolutePath());
            conf.set("phoenix.queryserver.tls.truststore.password", TlsUtil.getTrustStorePassword());
        }
        conf.set("phoenix.queryserver.kerberos.http.principal", SPNEGO_PRINCIPAL + "@" + this.KDC.getRealm());
        conf.set("phoenix.queryserver.http.keytab.file", this.KEYTAB.getAbsolutePath());
        conf.set("phoenix.queryserver.kerberos.principal", PQS_PRINCIPAL + "@" + this.KDC.getRealm());
        conf.set("phoenix.queryserver.keytab.file", this.KEYTAB.getAbsolutePath());
        conf.setBoolean("phoenix.queryserver.disable.kerberos.login", true);
        conf.setInt("phoenix.queryserver.http.port", 0);
        conf.set("hadoop.proxyuser.phoenixqs.groups", "*");
        conf.set("hadoop.proxyuser.phoenixqs.hosts", "*");
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        QueryServerEnvironment.updateDefaultRealm();
        this.UTIL.startMiniDFSCluster(1);
        Path rootdir = this.UTIL.getDataTestDirOnTestFS(QueryServerEnvironment.class.getSimpleName());
        conf.set("hbase.rootdir", rootdir.toString());
        this.HBASE_CLUSTER = new LocalHBaseCluster(conf, 1);
        this.HBASE_CLUSTER.startup();
        this.configureAndStartQueryServer(tls);
    }

    private void configureAndStartQueryServer(boolean tls) throws Exception {
        this.PQS = new QueryServer(new String[0], this.UTIL.getConfiguration());
        final UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)PQS_PRINCIPAL, (String)this.KEYTAB.getAbsolutePath());
        this.PQS_EXECUTOR = Executors.newSingleThreadExecutor();
        this.PQS_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                ugi.doAs((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        QueryServerEnvironment.this.PQS.run();
                        return null;
                    }
                });
            }
        });
        this.PQS.awaitRunning();
        this.PQS_PORT = this.PQS.getPort();
        this.PQS_URL = ThinClientUtil.getConnectionUrl((String)(tls ? "https" : "http"), (String)"localhost", (int)this.PQS_PORT) + ";authentication=SPNEGO" + (tls ? ";truststore=" + TlsUtil.getTrustStoreFile().getAbsolutePath() + ";truststore_password=" + TlsUtil.getTrustStorePassword() : "");
        LOG.debug("Phoenix Query Server URL: {}", (Object)this.PQS_URL);
    }

    public void stop() throws Exception {
        InstanceResolver.clearSingletons();
        if (this.PQS_EXECUTOR != null) {
            this.PQS.stop();
            this.PQS_EXECUTOR.shutdown();
            if (!this.PQS_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.info("PQS didn't exit in 5 seconds, proceeding anyways.");
            }
        }
        if (this.HBASE_CLUSTER != null) {
            this.HBASE_CLUSTER.shutdown();
            this.HBASE_CLUSTER.join();
        }
        if (this.UTIL != null) {
            this.UTIL.shutdownMiniZKCluster();
        }
        if (this.KDC != null) {
            this.KDC.stop();
        }
    }

    static {
        try {
            LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME = InetAddress.getByName("127.0.0.1").getCanonicalHostName();
            String userName = System.getProperty("user.name");
            LOGIN_USER = userName != null ? userName : "securecluster";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SPNEGO_PRINCIPAL = "HTTP/" + LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
        PQS_PRINCIPAL = "phoenixqs/" + LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
        SERVICE_PRINCIPAL = LOGIN_USER + "/" + LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
    }
}

