/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import java.util.Arrays;
import java.util.List;
import org.apache.drill.exec.store.phoenix.secured.QueryServerEnvironment;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.TlsUtil;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class HttpParamImpersonationQueryServerIT {
    public static QueryServerEnvironment environment;
    private static final List<TableName> SYSTEM_TABLE_NAMES;

    public static synchronized void startQueryServerEnvironment() throws Exception {
        if (environment != null) {
            HttpParamImpersonationQueryServerIT.stopEnvironment();
        }
        Configuration conf = new Configuration();
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{AccessController.class.getName()});
        conf.setStrings("hbase.coprocessor.regionserver.classes", new String[]{AccessController.class.getName()});
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{AccessController.class.getName(), TokenProvider.class.getName()});
        conf.set(String.format("hadoop.proxyuser.%s.hosts", QueryServerEnvironment.LOGIN_USER), "*");
        conf.set(String.format("hadoop.proxyuser.%s.users", QueryServerEnvironment.LOGIN_USER), "user1,user2");
        conf.setBoolean("phoenix.queryserver.withRemoteUserExtractor", true);
        environment = new QueryServerEnvironment(conf, 3, false);
    }

    public static synchronized void stopEnvironment() throws Exception {
        environment.stop();
        environment = null;
    }

    public static String getUrlTemplate() {
        String url = "jdbc:phoenix:thin:url=%s://localhost:" + environment.getPqsPort() + "?" + "doAs" + "=%s;authentication=SPNEGO;serialization=PROTOBUF%s";
        if (environment.getTls()) {
            return String.format(url, "https", "%s", ";truststore=" + TlsUtil.getTrustStoreFile().getAbsolutePath() + ";truststore_password=" + TlsUtil.getTrustStorePassword());
        }
        return String.format(url, "http", "%s", "");
    }

    static void grantUsersToPhoenixSystemTables(List<String> usersToGrant) throws Exception {
        try {
            for (String user : usersToGrant) {
                for (TableName tn : SYSTEM_TABLE_NAMES) {
                    AccessControlClient.grant((Connection)environment.getUtil().getConnection(), (TableName)tn, (String)user, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.EXEC});
                }
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    static void grantUsersToGlobalPhoenixUserTables(List<String> usersToGrant) throws Exception {
        try {
            for (String user : usersToGrant) {
                AccessControlClient.grant((Connection)environment.getUtil().getConnection(), (String)user, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.EXEC});
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    static {
        SYSTEM_TABLE_NAMES = Arrays.asList(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME, PhoenixDatabaseMetaData.SYSTEM_MUTEX_HBASE_TABLE_NAME, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_HBASE_TABLE_NAME, PhoenixDatabaseMetaData.SYSTEM_SCHEMA_HBASE_TABLE_NAME, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_HBASE_TABLE_NAME, PhoenixDatabaseMetaData.SYSTEM_STATS_HBASE_TABLE_NAME);
    }
}

