/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.QueryServerThread;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ThinClientUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServerBasicsIT
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(QueryServerBasicsIT.class);
    private static QueryServerThread AVATICA_SERVER;
    private static Configuration CONF;
    protected static String CONN_STRING;

    public static synchronized void doSetup() throws Exception {
        QueryServerBasicsIT.setUpTestDriver((ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS);
        CONF = config;
        if (System.getProperty("do.not.randomize.pqs.port") == null) {
            CONF.setInt("phoenix.queryserver.http.port", 0);
        }
        String url = QueryServerBasicsIT.getUrl();
        AVATICA_SERVER = new QueryServerThread(new String[]{url}, CONF, QueryServerBasicsIT.class.getName());
        AVATICA_SERVER.start();
        AVATICA_SERVER.getQueryServer().awaitRunning();
        int port = AVATICA_SERVER.getQueryServer().getPort();
        logger.info("Avatica server started on port " + port);
        CONN_STRING = ThinClientUtil.getConnectionUrl((String)"localhost", (int)port);
        logger.info("JDBC connection string is " + CONN_STRING);
    }

    public static void testCatalogs() throws Exception {
        try (Connection connection = DriverManager.getConnection(CONN_STRING);){
            Assert.assertFalse((boolean)connection.isClosed());
            try (ResultSet resultSet = connection.getMetaData().getCatalogs();){
                ResultSetMetaData metaData = resultSet.getMetaData();
                Assert.assertFalse((String)"unexpected populated resultSet", (boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)metaData.getColumnCount());
                Assert.assertEquals((Object)"TABLE_CAT", (Object)metaData.getColumnName(1));
            }
        }
    }

    public static synchronized void afterClass() throws Exception {
        if (AVATICA_SERVER != null) {
            AVATICA_SERVER.join(TimeUnit.SECONDS.toSeconds(3L));
            Throwable t = AVATICA_SERVER.getQueryServer().getThrowable();
            if (t != null) {
                Assert.fail((String)("query server threw. " + t.getMessage()));
            }
            Assert.assertEquals((String)"query server didn't exit cleanly", (long)0L, (long)AVATICA_SERVER.getQueryServer().getRetCode());
        }
    }
}

