/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.kafka.KafkaAsyncCloser;
import org.apache.drill.exec.store.kafka.KafkaGroupScan;
import org.apache.drill.exec.store.kafka.KafkaPushDownFilterIntoScan;
import org.apache.drill.exec.store.kafka.KafkaScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;
import org.apache.drill.exec.store.kafka.schema.KafkaSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(KafkaStoragePlugin.class);
    private final KafkaSchemaFactory kafkaSchemaFactory;
    private final KafkaStoragePluginConfig config;
    private final KafkaAsyncCloser closer;

    public KafkaStoragePlugin(KafkaStoragePluginConfig config, DrillbitContext context, String name) {
        super(context, name);
        logger.debug("Initializing {}", (Object)KafkaStoragePlugin.class.getName());
        this.config = config;
        this.kafkaSchemaFactory = new KafkaSchemaFactory(this, name);
        this.closer = new KafkaAsyncCloser();
    }

    public KafkaStoragePluginConfig getConfig() {
        return this.config;
    }

    public boolean supportsRead() {
        return true;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        this.kafkaSchemaFactory.registerSchemas(schemaConfig, parent);
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules(OptimizerRulesContext optimizerRulesContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: {
                return ImmutableSet.of((Object)KafkaPushDownFilterIntoScan.INSTANCE);
            }
        }
        return ImmutableSet.of();
    }

    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        KafkaScanSpec kafkaScanSpec = (KafkaScanSpec)selection.getListWith((TypeReference)new TypeReference<KafkaScanSpec>(){});
        return new KafkaGroupScan(this, kafkaScanSpec, null, -1);
    }

    public void registerToClose(AutoCloseable autoCloseable) {
        this.closer.close(autoCloseable);
    }

    public void close() {
        this.closer.close();
    }
}

