/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAsyncCloser
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaAsyncCloser.class);
    private volatile ExecutorService executorService;

    public void close(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            ExecutorService executorService = this.executorService();
            executorService.submit(() -> {
                try {
                    autoCloseable.close();
                    logger.debug("Closing {} resource", (Object)autoCloseable.getClass().getCanonicalName());
                }
                catch (Exception e) {
                    logger.debug("Resource {} failed to close: {}", (Object)autoCloseable.getClass().getCanonicalName(), (Object)e.getMessage());
                }
            });
        }
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            logger.trace("Closing Kafka async closer: {}", (Object)this.executorService);
            this.executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService executorService() {
        if (this.executorService == null) {
            KafkaAsyncCloser kafkaAsyncCloser = this;
            synchronized (kafkaAsyncCloser) {
                if (this.executorService == null) {
                    this.executorService = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new KafkaThreadFactory());
                }
            }
        }
        return this.executorService;
    }

    private static class KafkaThreadFactory
    implements ThreadFactory {
        private static final String THREAD_PREFIX = "drill-kafka-closer-";
        private final ThreadFactory delegate = Executors.defaultThreadFactory();

        private KafkaThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.delegate.newThread(runnable);
            thread.setName(THREAD_PREFIX + thread.getName());
            return thread;
        }
    }
}

