/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;
import org.apache.drill.exec.store.kafka.TestKafkaSuite;
import org.apache.drill.exec.store.kafka.cluster.EmbeddedKafkaCluster;
import org.apache.drill.exec.store.kafka.decoders.JsonMessageReader;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;

public class KafkaTestBase
extends ClusterTest {
    protected static KafkaStoragePluginConfig storagePluginConfig;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Assume.assumeTrue((boolean)TestKafkaSuite.isRunningSuite());
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        KafkaTestBase.startCluster((ClusterFixtureBuilder)builder);
        TestKafkaSuite.initKafka();
        KafkaTestBase.initKafkaStoragePlugin(TestKafkaSuite.embeddedKafkaCluster);
    }

    public static void initKafkaStoragePlugin(EmbeddedKafkaCluster embeddedKafkaCluster) throws Exception {
        StoragePluginRegistry pluginRegistry = cluster.drillbit().getContext().getStorage();
        HashMap kafkaConsumerProps = Maps.newHashMap();
        kafkaConsumerProps.put("bootstrap.servers", embeddedKafkaCluster.getKafkaBrokerList());
        kafkaConsumerProps.put("group.id", "drill-test-consumer");
        kafkaConsumerProps.put("schema.registry.url", "mock://testurl");
        storagePluginConfig = new KafkaStoragePluginConfig((Map)kafkaConsumerProps);
        storagePluginConfig.setEnabled(Boolean.valueOf(true));
        pluginRegistry.put("kafka", (StoragePluginConfig)storagePluginConfig);
        client.alterSession("store.kafka.record.reader", (Object)JsonMessageReader.class.getName());
        client.alterSession("store.kafka.poll.timeout", (Object)5000);
    }

    public void runKafkaSQLVerifyCount(String sql, int expectedRowCount) {
        long rowCount = this.queryBuilder().sql(sql).log();
        if (expectedRowCount != -1) {
            Assert.assertEquals((long)expectedRowCount, (long)rowCount);
        }
    }

    public static long testSql(String sql) {
        return client.queryBuilder().sql(sql).log();
    }

    @AfterClass
    public static void tearDownKafkaTestBase() {
        if (TestKafkaSuite.isRunningSuite()) {
            TestKafkaSuite.tearDownCluster();
        }
    }
}

