/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;

@JsonTypeName(value="kafka-partition-scan")
public class KafkaSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "KAFKA_SUB_SCAN";
    private final KafkaStoragePlugin kafkaStoragePlugin;
    private final List<SchemaPath> columns;
    private final List<KafkaPartitionScanSpec> partitionSubScanSpecList;

    @JsonCreator
    public KafkaSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="kafkaStoragePluginConfig") KafkaStoragePluginConfig kafkaStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="partitionSubScanSpecList") LinkedList<KafkaPartitionScanSpec> partitionSubScanSpecList) throws ExecutionSetupException {
        this(userName, (KafkaStoragePlugin)registry.resolve((StoragePluginConfig)kafkaStoragePluginConfig, KafkaStoragePlugin.class), columns, partitionSubScanSpecList);
    }

    public KafkaSubScan(String userName, KafkaStoragePlugin kafkaStoragePlugin, List<SchemaPath> columns, List<KafkaPartitionScanSpec> partitionSubScanSpecList) {
        super(userName);
        this.kafkaStoragePlugin = kafkaStoragePlugin;
        this.columns = columns;
        this.partitionSubScanSpecList = partitionSubScanSpecList;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KafkaSubScan(this.getUserName(), this.kafkaStoragePlugin, this.columns, this.partitionSubScanSpecList);
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    @JsonProperty
    public KafkaStoragePluginConfig getKafkaStoragePluginConfig() {
        return this.kafkaStoragePlugin.getConfig();
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<KafkaPartitionScanSpec> getPartitionSubScanSpecList() {
        return this.partitionSubScanSpecList;
    }

    @JsonIgnore
    public KafkaStoragePlugin getKafkaStoragePlugin() {
        return this.kafkaStoragePlugin;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

