/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.zk.KafkaZkClient;
import org.apache.drill.categories.KafkaStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.ZookeeperTestUtil;
import org.apache.drill.exec.store.kafka.KafkaFilterPushdownTest;
import org.apache.drill.exec.store.kafka.KafkaMessageGenerator;
import org.apache.drill.exec.store.kafka.KafkaQueriesTest;
import org.apache.drill.exec.store.kafka.MessageIteratorTest;
import org.apache.drill.exec.store.kafka.cluster.EmbeddedKafkaCluster;
import org.apache.drill.exec.store.kafka.decoders.MessageReaderFactoryTest;
import org.apache.drill.test.BaseTest;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

@Category(value={KafkaStorageTest.class, SlowTest.class})
@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={KafkaQueriesTest.class, MessageIteratorTest.class, MessageReaderFactoryTest.class, KafkaFilterPushdownTest.class})
public class TestKafkaSuit
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(TestKafkaSuit.class);
    private static final String LOGIN_CONF_RESOURCE_PATHNAME = "login.conf";
    public static EmbeddedKafkaCluster embeddedKafkaCluster;
    private static KafkaZkClient zkClient;
    private static final AtomicInteger initCount;
    static final int NUM_JSON_MSG = 10;
    private static final int CONN_TIMEOUT = 8000;
    private static final int SESSION_TIMEOUT = 10000;
    private static volatile boolean runningSuite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initKafka() throws Exception {
        Class<TestKafkaSuit> clazz = TestKafkaSuit.class;
        synchronized (TestKafkaSuit.class) {
            if (initCount.get() == 0) {
                ZookeeperTestUtil.setZookeeperSaslTestConfigProps();
                System.setProperty("java.security.auth.login.config", ClassLoader.getSystemResource(LOGIN_CONF_RESOURCE_PATHNAME).getFile());
                embeddedKafkaCluster = new EmbeddedKafkaCluster();
                zkClient = KafkaZkClient.apply((String)embeddedKafkaCluster.getZkServer().getConnectionString(), (boolean)false, (int)10000, (int)8000, (int)0, (Time)Time.SYSTEM, (String)"kafka.server", (String)"SessionExpireListener", (Option)Option.empty(), (Option)Option.empty());
                TestKafkaSuit.createTopicHelper("drill-json-topic", 1);
                TestKafkaSuit.createTopicHelper("drill-avro-topic", 1);
                KafkaMessageGenerator generator = new KafkaMessageGenerator(embeddedKafkaCluster.getKafkaBrokerList(), StringSerializer.class);
                KafkaMessageGenerator avroGenerator = new KafkaMessageGenerator(embeddedKafkaCluster.getKafkaBrokerList(), KafkaAvroSerializer.class);
                generator.populateJsonMsgIntoKafka("drill-json-topic", 10);
                avroGenerator.populateAvroMsgIntoKafka("drill-avro-topic", 10);
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            logger.info("Initialized Embedded Zookeeper and Kafka");
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() {
        Class<TestKafkaSuit> clazz = TestKafkaSuit.class;
        synchronized (TestKafkaSuit.class) {
            if (initCount.decrementAndGet() == 0) {
                if (zkClient != null) {
                    zkClient.close();
                    zkClient = null;
                }
                if (embeddedKafkaCluster != null && !embeddedKafkaCluster.getBrokers().isEmpty()) {
                    embeddedKafkaCluster.shutDownCluster();
                    embeddedKafkaCluster = null;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void createTopicHelper(String topicName, int partitions) throws ExecutionException, InterruptedException {
        try (AdminClient adminClient = TestKafkaSuit.initAdminClient();){
            NewTopic newTopic = new NewTopic(topicName, partitions, 1);
            HashMap<String, String> topicConfigs = new HashMap<String, String>();
            topicConfigs.put("message.timestamp.type", "CreateTime");
            topicConfigs.put("retention.ms", "-1");
            newTopic.configs(topicConfigs);
            CreateTopicsResult result = adminClient.createTopics(Collections.singletonList(newTopic));
            result.all().get();
        }
    }

    private static AdminClient initAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", embeddedKafkaCluster.getKafkaBrokerList());
        return AdminClient.create((Properties)props);
    }

    static {
        initCount = new AtomicInteger(0);
        runningSuite = true;
    }
}

