/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.decoders;

import org.apache.drill.categories.KafkaStorageTest;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.kafka.decoders.JsonMessageReader;
import org.apache.drill.exec.store.kafka.decoders.MessageReader;
import org.apache.drill.exec.store.kafka.decoders.MessageReaderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={KafkaStorageTest.class})
public class MessageReaderFactoryTest {
    @Test
    public void testShouldThrowExceptionAsMessageReaderIsNull() {
        try {
            MessageReaderFactory.getMessageReader(null);
            Assert.fail((String)"Message reader initialization succeeded even though it is null");
        }
        catch (UserException ue) {
            Assert.assertTrue((ue.getErrorType() == UserBitShared.DrillPBError.ErrorType.VALIDATION ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ue.getMessage().contains("VALIDATION ERROR: Please configure message reader implementation using the property 'store.kafka.record.reader'"));
        }
    }

    @Test
    public void testShouldThrowExceptionAsMessageReaderHasNotImplementedMessageReaderIntf() {
        try {
            MessageReaderFactory.getMessageReader((String)MessageReaderFactoryTest.class.getName());
            Assert.fail((String)"Message reader initialization succeeded even though class does not implement message reader interface");
        }
        catch (UserException ue) {
            Assert.assertTrue((ue.getErrorType() == UserBitShared.DrillPBError.ErrorType.VALIDATION ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ue.getMessage().contains("VALIDATION ERROR: Message reader configured 'org.apache.drill.exec.store.kafka.decoders.MessageReaderFactoryTest' does not implement 'org.apache.drill.exec.store.kafka.decoders.MessageReader'"));
        }
    }

    @Test
    public void testShouldThrowExceptionAsNoClassFound() {
        try {
            MessageReaderFactory.getMessageReader((String)"a.b.c.d");
            Assert.fail((String)"Message reader initialization succeeded even though class does not exist");
        }
        catch (UserException ue) {
            Assert.assertTrue((ue.getErrorType() == UserBitShared.DrillPBError.ErrorType.VALIDATION ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ue.getMessage().contains("VALIDATION ERROR: Failed to initialize message reader : a.b.c.d"));
        }
    }

    @Test
    public void testShouldReturnJsonMessageReaderInstance() {
        MessageReader messageReader = MessageReaderFactory.getMessageReader((String)JsonMessageReader.class.getName());
        Assert.assertTrue((boolean)(messageReader instanceof JsonMessageReader));
    }
}

