/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.ZKStringSerializer$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.drill.categories.KafkaStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.ZookeeperTestUtil;
import org.apache.drill.exec.store.kafka.KafkaFilterPushdownTest;
import org.apache.drill.exec.store.kafka.KafkaMessageGenerator;
import org.apache.drill.exec.store.kafka.KafkaQueriesTest;
import org.apache.drill.exec.store.kafka.MessageIteratorTest;
import org.apache.drill.exec.store.kafka.cluster.EmbeddedKafkaCluster;
import org.apache.drill.exec.store.kafka.decoders.MessageReaderFactoryTest;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={KafkaStorageTest.class, SlowTest.class})
@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={KafkaQueriesTest.class, MessageIteratorTest.class, MessageReaderFactoryTest.class, KafkaFilterPushdownTest.class})
public class TestKafkaSuit {
    private static final Logger logger = LoggerFactory.getLogger(LoggerFactory.class);
    private static final String LOGIN_CONF_RESOURCE_PATHNAME = "login.conf";
    public static EmbeddedKafkaCluster embeddedKafkaCluster;
    private static ZkClient zkClient;
    private static volatile AtomicInteger initCount;
    static final int NUM_JSON_MSG = 10;
    static final int CONN_TIMEOUT = 8000;
    static final int SESSION_TIMEOUT = 10000;
    static String kafkaBroker;
    private static volatile boolean runningSuite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initKafka() throws Exception {
        Class<TestKafkaSuit> clazz = TestKafkaSuit.class;
        synchronized (TestKafkaSuit.class) {
            if (initCount.get() == 0) {
                ZookeeperTestUtil.setZookeeperSaslTestConfigProps();
                System.setProperty("java.security.auth.login.config", ClassLoader.getSystemResource(LOGIN_CONF_RESOURCE_PATHNAME).getFile());
                embeddedKafkaCluster = new EmbeddedKafkaCluster();
                zkClient = new ZkClient(embeddedKafkaCluster.getZkServer().getConnectionString(), 10000, 8000, (ZkSerializer)ZKStringSerializer$.MODULE$);
                TestKafkaSuit.createTopicHelper("drill-json-topic", 1);
                KafkaMessageGenerator generator = new KafkaMessageGenerator(embeddedKafkaCluster.getKafkaBrokerList(), StringSerializer.class);
                generator.populateJsonMsgIntoKafka("drill-json-topic", 10);
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            logger.info("Initialized Embedded Zookeeper and Kafka");
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() throws Exception {
        Class<TestKafkaSuit> clazz = TestKafkaSuit.class;
        synchronized (TestKafkaSuit.class) {
            if (initCount.decrementAndGet() == 0) {
                if (zkClient != null) {
                    zkClient.close();
                }
                if (embeddedKafkaCluster != null && !embeddedKafkaCluster.getBrokers().isEmpty()) {
                    embeddedKafkaCluster.shutDownCluster();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void createTopicHelper(String topicName, int partitions) throws ExecutionException, InterruptedException {
        try (AdminClient adminClient = TestKafkaSuit.initAdminClient();){
            NewTopic newTopic = new NewTopic(topicName, partitions, 1);
            HashMap<String, String> topicConfigs = new HashMap<String, String>();
            topicConfigs.put("message.timestamp.type", "CreateTime");
            topicConfigs.put("retention.ms", "-1");
            newTopic.configs(topicConfigs);
            CreateTopicsResult result = adminClient.createTopics(Collections.singletonList(newTopic));
            result.all().get();
        }
    }

    private static AdminClient initAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", embeddedKafkaCluster.getKafkaBrokerList());
        return AdminClient.create((Properties)props);
    }

    static {
        initCount = new AtomicInteger(0);
        runningSuite = false;
    }
}

