/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.decoders;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.kafka.decoders.MessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(MessageReaderFactory.class);

    public static MessageReader getMessageReader(String messageReaderKlass) {
        if (messageReaderKlass == null) {
            throw UserException.validationError().message("Please configure message reader implementation using the property 'store.kafka.record.reader'", new Object[0]).build(logger);
        }
        MessageReader messageReader = null;
        try {
            Class<?> klass = Class.forName(messageReaderKlass);
            if (MessageReader.class.isAssignableFrom(klass)) {
                messageReader = (MessageReader)klass.newInstance();
                logger.info("Initialized Message Reader : {}", (Object)messageReader);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw UserException.validationError().message("Failed to initialize message reader : %s", new Object[]{messageReaderKlass}).build(logger);
        }
        if (messageReader == null) {
            throw UserException.validationError().message("Message reader configured '%s' does not implement '%s'", new Object[]{messageReaderKlass, MessageReader.class.getName()}).build(logger);
        }
        return messageReader;
    }
}

