/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.decoders;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.MetaDataField;
import org.apache.drill.exec.store.kafka.decoders.MessageReader;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessageReader
implements MessageReader {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageReader.class);
    private JsonReader jsonReader;
    private VectorContainerWriter writer;

    @Override
    public void init(DrillBuf buf, List<SchemaPath> columns, VectorContainerWriter writer, boolean allTextMode, boolean readNumbersAsDouble) {
        this.jsonReader = new JsonReader.Builder(buf).schemaPathColumns(columns).allTextMode(allTextMode).readNumbersAsDouble(readNumbersAsDouble).build();
        this.writer = writer;
    }

    @Override
    public void readMessage(ConsumerRecord<?, ?> record) {
        try {
            byte[] recordArray = (byte[])record.value();
            JsonObject jsonObj = new JsonParser().parse(new String(recordArray, Charsets.UTF_8)).getAsJsonObject();
            jsonObj.addProperty(MetaDataField.KAFKA_TOPIC.getFieldName(), record.topic());
            jsonObj.addProperty(MetaDataField.KAFKA_PARTITION_ID.getFieldName(), (Number)record.partition());
            jsonObj.addProperty(MetaDataField.KAFKA_OFFSET.getFieldName(), (Number)record.offset());
            jsonObj.addProperty(MetaDataField.KAFKA_TIMESTAMP.getFieldName(), (Number)record.timestamp());
            jsonObj.addProperty(MetaDataField.KAFKA_MSG_KEY.getFieldName(), record.key() != null ? record.key().toString() : null);
            if (record.headers() != null) {
                Arrays.stream(record.headers().toArray()).forEach(x -> jsonObj.addProperty(x.key(), new String(x.value(), Charsets.UTF_8)));
            }
            this.jsonReader.setSource(jsonObj.toString().getBytes(Charsets.UTF_8));
            this.jsonReader.write((BaseWriter.ComplexWriter)this.writer);
        }
        catch (IOException e) {
            throw UserException.dataReadError((Throwable)e).message(e.getMessage(), new Object[0]).addContext("MessageReader", JsonMessageReader.class.getName()).build(logger);
        }
    }

    @Override
    public void ensureAtLeastOneField() {
        this.jsonReader.ensureAtLeastOneField((BaseWriter.ComplexWriter)this.writer);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> getConsumer(KafkaStoragePlugin plugin) {
        return plugin.registerConsumer((KafkaConsumer<byte[], byte[]>)new KafkaConsumer(plugin.getConfig().getKafkaConsumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
    }

    @Override
    public void close() throws IOException {
        this.writer.clear();
        try {
            this.writer.close();
        }
        catch (Exception e) {
            logger.warn("Error while closing JsonMessageReader", (Throwable)e);
        }
    }

    public String toString() {
        return "JsonMessageReader[jsonReader=" + this.jsonReader + "]";
    }
}

