/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import ch.qos.logback.classic.Level;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.physical.impl.project.ProjectMemoryManager;
import org.apache.drill.exec.physical.impl.project.ProjectRecordBatch;
import org.apache.drill.exec.physical.impl.validate.IteratorValidatorBatchIterator;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpJsonOptions;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.exec.store.http.udfs.HttpUdfUtils;
import org.apache.drill.exec.store.http.util.SimpleHttp;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.LogFixture;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpUDFFunctions
extends ClusterTest {
    private static final int MOCK_SERVER_PORT = 47771;
    private static String TEST_JSON_RESPONSE;
    private static String TEST_JSON_PAGE1;
    private static String DUMMY_URL;
    protected static LogFixture logFixture;
    private static final Level CURRENT_LOG_LEVEL;

    @BeforeClass
    public static void setup() throws Exception {
        logFixture = LogFixture.builder().toConsole().logger(ProjectMemoryManager.class, CURRENT_LOG_LEVEL).logger(ProjectRecordBatch.class, CURRENT_LOG_LEVEL).logger(JsonLoaderImpl.class, CURRENT_LOG_LEVEL).logger(IteratorValidatorBatchIterator.class, CURRENT_LOG_LEVEL).logger(ResultSetLoaderImpl.class, CURRENT_LOG_LEVEL).logger(HttpUdfUtils.class, CURRENT_LOG_LEVEL).build();
        TestHttpUDFFunctions.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TEST_JSON_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/simple.json"), (Charset)Charsets.UTF_8).read();
        TEST_JSON_PAGE1 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/p1.json"), (Charset)Charsets.UTF_8).read();
        HttpApiConfig mockGithubWithDuplicateParam = HttpApiConfig.builder().url(String.format("%s/orgs/{org}/repos", DUMMY_URL)).method("GET").params(Arrays.asList("org", "lng", "date")).dataPath("results").requireTail(false).build();
        TupleMetadata simpleSchema = new SchemaBuilder().addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).build();
        HttpJsonOptions jsonOptions = new HttpJsonOptions.HttpJsonOptionsBuilder().schema(simpleSchema).build();
        HttpApiConfig basicJson = HttpApiConfig.builder().url(String.format("%s/json", DUMMY_URL)).method("get").jsonOptions(jsonOptions).requireTail(false).inputType("json").build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("github", mockGithubWithDuplicateParam);
        configs.put("basicJson", basicJson);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(200), Integer.valueOf(1000), "globaluser", "globalpass", "", Integer.valueOf(80), "", "", "", null, (CredentialsProvider)new PlainCredentialsProvider((Map)ImmutableMap.of((Object)"username", (Object)"globaluser", (Object)"password", (Object)"globalpass")), StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("local", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    @Test
    public void testProvidedSchema() throws Exception {
        String sql = "SELECT http_request('local.basicJson') as data FROM (values(1))";
        try (MockWebServer server = TestHttpUDFFunctions.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)1L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("data").addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1.0, 2.0, 3.0}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testSeveralRowsAndRequests() throws Exception {
        String sql = "SELECT http_request('local.basicJson', `col1`) as data FROM cp.`/data/p4.json`";
        try (MockWebServer server = TestHttpUDFFunctions.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)2L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("data").addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1.0, 2.0, 3.0}))).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{4.0, 5.0, 6.0}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testHttpGetWithNoParams() throws Exception {
        try (MockWebServer server = TestHttpUDFFunctions.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT http_get('" + DUMMY_URL + "') AS result FROM (values(1))";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)1L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("result").addMap("results").addNullable("sunrise", TypeProtos.MinorType.VARCHAR).addNullable("sunset", TypeProtos.MinorType.VARCHAR).addNullable("solar_noon", TypeProtos.MinorType.VARCHAR).addNullable("day_length", TypeProtos.MinorType.VARCHAR).addNullable("civil_twilight_begin", TypeProtos.MinorType.VARCHAR).addNullable("civil_twilight_end", TypeProtos.MinorType.VARCHAR).addNullable("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR).addNullable("nautical_twilight_end", TypeProtos.MinorType.VARCHAR).addNullable("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR).addNullable("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR).resumeMap().addNullable("status", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            results.clear();
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"GET", (Object)recordedRequest.getMethod());
            Assert.assertEquals((Object)String.format("%s/", DUMMY_URL), (Object)recordedRequest.getRequestUrl().toString());
        }
    }

    @Test
    public void testHttpGetWithParams() throws Exception {
        try (MockWebServer server = TestHttpUDFFunctions.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT http_get('" + DUMMY_URL + "/{p1}/{p2}', 'param1', 'param2') AS result FROM (values(1))";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)1L, (long)results.rowCount());
            results.clear();
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"GET", (Object)recordedRequest.getMethod());
            Assert.assertEquals((Object)String.format("%s/param1/param2", DUMMY_URL), (Object)recordedRequest.getRequestUrl().toString());
        }
    }

    @Test
    public void testHttpGetFromPlugin() throws Exception {
        try (MockWebServer server = TestHttpUDFFunctions.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT http_request('local.github', 'apache') AS result FROM (values(1))";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)1L, (long)results.rowCount());
            results.clear();
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"GET", (Object)recordedRequest.getMethod());
            Assert.assertEquals((Object)String.format("%s/orgs/apache/repos", DUMMY_URL), (Object)recordedRequest.getRequestUrl().toString());
        }
    }

    @Test
    public void testHttpGetWithInvalidPlugin() {
        try {
            String sql = "SELECT http_request('nope.nothere', 'apache') AS result FROM (values(1))";
            client.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("FUNCTION ERROR: nope is not a valid plugin."));
        }
    }

    @Test
    public void testNullParam() throws Exception {
        String sql = "SELECT http_get('" + DUMMY_URL + "/{p1}/{p2}', 'param1', null) AS result FROM (values(1))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        Assert.assertEquals((long)0L, (long)results.container().getLast().getField().getChildCount());
        results.clear();
        sql = "SELECT http_request('local.github', null) AS result FROM (values(1))";
        results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        Assert.assertEquals((long)0L, (long)results.container().getLast().getField().getChildCount());
        results.clear();
    }

    @Test
    public void testPositionalReplacement() {
        String url = "http://somesite.com/{p1}/{p2}/path/{}";
        ArrayList<String> params = new ArrayList<String>();
        params.add("foo");
        params.add("bar");
        params.add("baz");
        Assert.assertEquals((Object)"http://somesite.com/foo/bar/path/baz", (Object)SimpleHttp.mapPositionalParameters((String)url, params));
    }

    public static MockWebServer startServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.start(47771);
        return server;
    }

    static {
        DUMMY_URL = "http://localhost:47771";
        CURRENT_LOG_LEVEL = Level.DEBUG;
    }
}

