/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.util.Base64;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpStoragePlugin;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClientFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUserTranslationInHttpPlugin
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(TestUserTranslationInHttpPlugin.class);
    private static final int MOCK_SERVER_PORT = 47778;
    private static String TEST_JSON_RESPONSE_WITH_DATATYPES;
    private static String ACCESS_TOKEN_RESPONSE;
    private static int portNumber;
    @ClassRule
    public static final BaseDirTestWatcher dirTestWatcher;

    @After
    public void cleanup() throws Exception {
        FileUtils.cleanDirectory((File)dirTestWatcher.getStoreDir());
    }

    @BeforeClass
    public static void setup() throws Exception {
        TEST_JSON_RESPONSE_WITH_DATATYPES = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response2.json"), (Charset)Charsets.UTF_8).read();
        ACCESS_TOKEN_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/oauth_access_token_response.json"), (Charset)Charsets.UTF_8).read();
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true);
        TestUserTranslationInHttpPlugin.startCluster((ClusterFixtureBuilder)builder);
        portNumber = cluster.drillbit().getWebServerPort();
        HttpApiConfig testEndpoint = HttpApiConfig.builder().url(TestUserTranslationInHttpPlugin.makeUrl("http://localhost:%d/json")).method("GET").requireTail(false).authType("basic").errorOn400(true).build();
        OAuthConfig oAuthConfig = OAuthConfig.builder().callbackURL(TestUserTranslationInHttpPlugin.makeUrl("http://localhost:%d") + "/update_oauth2_authtoken").build();
        HashMap<String, String> oauthCreds = new HashMap<String, String>();
        oauthCreds.put("clientID", "12345");
        oauthCreds.put("clientSecret", "54321");
        oauthCreds.put("tokenURI", "http://localhost:47778/get_access_token");
        PlainCredentialsProvider oauthCredentialProvider = new PlainCredentialsProvider(oauthCreds);
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("sharedEndpoint", testEndpoint);
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", "user2user");
        credentials.put("password", "user2pass");
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider("testUser2", credentials);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(2), Integer.valueOf(1000), null, null, "", Integer.valueOf(80), "", "", "", null, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.USER_TRANSLATION.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        HttpStoragePluginConfig mockOAuthPlugin = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(2), Integer.valueOf(1000), null, null, "", Integer.valueOf(80), "", "", "", oAuthConfig, (CredentialsProvider)oauthCredentialProvider, StoragePluginConfig.AuthMode.USER_TRANSLATION.name());
        mockOAuthPlugin.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("local", (StoragePluginConfig)mockStorageConfigWithWorkspace);
        cluster.defineStoragePlugin("oauth", (StoragePluginConfig)mockOAuthPlugin);
    }

    @Test
    public void testEmptyUserCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        StoragePluginRegistry registry = cluster.storageRegistry();
        StoragePlugin plugin = registry.getPlugin("local");
        PlainCredentialsProvider credentialsProvider = (PlainCredentialsProvider)plugin.getConfig().getCredentialsProvider();
        Map credentials = credentialsProvider.getUserCredentials("testUser1");
        Assert.assertNotNull((Object)credentials);
        Assert.assertNull(credentials.get("username"));
        Assert.assertNull(credentials.get("password"));
    }

    @Test
    public void testQueryWithValidCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser2").property("password", (Object)"testUser2Password").build();
        try (MockWebServer server = TestUserTranslationInHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE_WITH_DATATYPES));
            String sql = "SELECT * FROM local.sharedEndpoint";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)results.rowCount(), (long)2L);
            results.clear();
            RecordedRequest recordedRequest = server.takeRequest();
            Headers headers = recordedRequest.getHeaders();
            Assert.assertEquals((Object)headers.get("Authorization"), (Object)TestUserTranslationInHttpPlugin.createEncodedText("user2user", "user2pass"));
        }
    }

    @Test
    public void testQueryWithMissingCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        try (MockWebServer server = TestUserTranslationInHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE_WITH_DATATYPES));
            String sql = "SELECT * FROM local.sharedEndpoint";
            try {
                client.queryBuilder().sql(sql).run();
                Assert.fail();
            }
            catch (UserException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("You do not have valid credentials for this API."));
            }
        }
    }

    @Test
    public void testQueryWithOAuth() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser2").property("password", (Object)"testUser2Password").build();
        try (MockWebServer server = TestUserTranslationInHttpPlugin.startServer();){
            PersistentTokenTable tokenTable = ((HttpStoragePlugin)cluster.storageRegistry().getPlugin("oauth")).getTokenRegistry("testUser2").getTokenTable("oauth");
            tokenTable.setAccessToken("you_have_access_2");
            tokenTable.setRefreshToken("refresh_me_2");
            Assert.assertEquals((Object)"you_have_access_2", (Object)tokenTable.getAccessToken());
            Assert.assertEquals((Object)"refresh_me_2", (Object)tokenTable.getRefreshToken());
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE_WITH_DATATYPES));
            String sql = "SELECT * FROM oauth.sharedEndpoint";
            DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("col_1", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).add("col_2", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("col_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1.0, 2, "3.0"}).addRow(new Object[]{4.0, 5, "6.0"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            String authToken = recordedRequest.getHeader("Authorization");
            Assert.assertEquals((Object)"you_have_access_2", (Object)authToken);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            Assert.fail();
        }
    }

    @Test
    public void testUnrelatedQueryWithUser() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        String sql = "SHOW FILES IN dfs";
        QueryBuilder.QuerySummary result = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)result.succeeded());
    }

    private static MockWebServer startServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.start(47778);
        return server;
    }

    private static String makeUrl(String url) {
        return String.format(url, 47778);
    }

    private static String createEncodedText(String username, String password) {
        String pair = username + ":" + password;
        byte[] encodedBytes = Base64.encodeBase64((byte[])pair.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encodedBytes, StandardCharsets.UTF_8);
    }

    static {
        dirTestWatcher = new BaseDirTestWatcher();
    }
}

