/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.user.security.testing.UserAuthenticatorTestImpl;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpJsonOptions;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClientFixture;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpUDFWithAliases
extends ClusterTest {
    private static AliasRegistry storageAliasesRegistry;
    private static AliasRegistry tableAliasesRegistry;
    private static final int MOCK_SERVER_PORT = 47778;
    private static String TEST_JSON_PAGE1;
    private static final String DUMMY_URL = "http://localhost:47778";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_JSON_PAGE1 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/p1.json"), (Charset)Charsets.UTF_8).read();
        cluster = ClusterFixture.bareBuilder((BaseDirTestWatcher)dirTestWatcher).configProperty("drill.exec.security.user.auth.enabled", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true).configProperty("drill.exec.security.user.auth.impl", (Object)"drillTestAuthenticator").configProperty("user", (Object)UserAuthenticatorTestImpl.PROCESS_USER).configProperty("password", (Object)"processUserPw").build();
        ClientFixture admin = cluster.clientBuilder().property("user", (Object)UserAuthenticatorTestImpl.PROCESS_USER).property("password", (Object)"processUserPw").build();
        admin.alterSystem("security.admin.users", (Object)("admin," + UserAuthenticatorTestImpl.PROCESS_USER));
        admin.alterSystem("security.admin.user_groups", (Object)"admingrp");
        client = cluster.clientBuilder().property("user", (Object)"admin").property("password", (Object)"adminUserPw").build();
        storageAliasesRegistry = cluster.drillbit().getContext().getAliasRegistryProvider().getStorageAliasesRegistry();
        tableAliasesRegistry = cluster.drillbit().getContext().getAliasRegistryProvider().getTableAliasesRegistry();
        TupleMetadata simpleSchema = new SchemaBuilder().addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).build();
        HttpJsonOptions jsonOptions = new HttpJsonOptions.HttpJsonOptionsBuilder().schema(simpleSchema).build();
        HttpApiConfig basicJson = HttpApiConfig.builder().url(String.format("%s/json", DUMMY_URL)).method("get").jsonOptions(jsonOptions).requireTail(false).inputType("json").build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("basicJson", basicJson);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(200), Integer.valueOf(1000), "globaluser", "globalpass", "", Integer.valueOf(80), "", "", "", null, (CredentialsProvider)new PlainCredentialsProvider((Map)ImmutableMap.of((Object)"username", (Object)"globaluser", (Object)"password", (Object)"globalpass")), StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("local", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeveralRowsAndRequestsAndPublicStorageAlias() throws Exception {
        storageAliasesRegistry.createPublicAliases();
        storageAliasesRegistry.getPublicAliases().put("`foobar`", "`local`", false);
        String sql = "SELECT http_request('foobar.basicJson', `col1`) as data FROM cp.`/data/p4.json`";
        try (MockWebServer server = TestHttpUDFWithAliases.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)2L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("data").addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1.0, 2.0, 3.0}))).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{4.0, 5.0, 6.0}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            storageAliasesRegistry.deletePublicAliases();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeveralRowsAndRequestsAndUserStorageAlias() throws Exception {
        String sql = "SELECT http_request('foobar.basicJson', `col1`) as data FROM cp.`/data/p4.json`";
        try (MockWebServer server = TestHttpUDFWithAliases.startServer();){
            ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser2").property("password", (Object)"testUser2Password").build();
            storageAliasesRegistry.createUserAliases("testUser2");
            storageAliasesRegistry.getUserAliases("testUser2").put("`foobar`", "`local`", false);
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)2L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("data").addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1.0, 2.0, 3.0}))).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{4.0, 5.0, 6.0}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            storageAliasesRegistry.deleteUserAliases("testUser2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeveralRowsAndRequestsAndPublicTableAlias() throws Exception {
        tableAliasesRegistry.createPublicAliases();
        tableAliasesRegistry.getPublicAliases().put("`foobar`", "`basicJson`", false);
        String sql = "SELECT http_request('local.foobar', `col1`) as data FROM cp.`/data/p4.json`";
        try (MockWebServer server = TestHttpUDFWithAliases.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)2L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("data").addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1.0, 2.0, 3.0}))).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{4.0, 5.0, 6.0}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            tableAliasesRegistry.deletePublicAliases();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeveralRowsAndRequestsAndUserTableAlias() throws Exception {
        String sql = "SELECT http_request('local.foobar', `col1`) as data FROM cp.`/data/p4.json`";
        try (MockWebServer server = TestHttpUDFWithAliases.startServer();){
            ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser2").property("password", (Object)"testUser2Password").build();
            tableAliasesRegistry.createUserAliases("testUser2");
            tableAliasesRegistry.getUserAliases("testUser2").put("`foobar`", "`basicJson`", false);
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((long)2L, (long)results.rowCount());
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("data").addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1.0, 2.0, 3.0}))).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{4.0, 5.0, 6.0}))).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            tableAliasesRegistry.deleteUserAliases("testUser2");
        }
    }

    public static MockWebServer startServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.start(47778);
        return server;
    }
}

