/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpJsonOptions;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestProvidedSchema
extends ClusterTest {
    private static final int MOCK_SERVER_PORT = 47777;
    private static String TEST_JSON_PAGE1;
    private static String TEST_SCHEMA_CHANGE1;

    @BeforeClass
    public static void setup() throws Exception {
        TestProvidedSchema.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TEST_JSON_PAGE1 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/p1.json"), (Charset)Charsets.UTF_8).read();
        TEST_SCHEMA_CHANGE1 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/schema_change_1.json"), (Charset)Charsets.UTF_8).read();
        dirTestWatcher.copyResourceToRoot(Paths.get("data/", new String[0]));
        TestProvidedSchema.makeMockConfig(cluster);
    }

    public static void makeMockConfig(ClusterFixture cluster) {
        TupleMetadata simpleSchema = new SchemaBuilder().addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).build();
        HttpJsonOptions jsonOptions = new HttpJsonOptions.HttpJsonOptionsBuilder().schema(simpleSchema).build();
        HttpApiConfig basicJson = HttpApiConfig.builder().url(TestProvidedSchema.makeUrl("http://localhost:%d/json")).method("get").jsonOptions(jsonOptions).requireTail(false).inputType("json").build();
        TupleMetadata mapSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addMap("field2").addNullable("nested_value1", TypeProtos.MinorType.VARCHAR).addNullable("nested_value2", TypeProtos.MinorType.VARCHAR).resumeSchema().buildSchema();
        HttpJsonOptions jsonOptionsSchemaChange = new HttpJsonOptions.HttpJsonOptionsBuilder().schema(mapSchema).skipMalformedRecords(Boolean.valueOf(true)).build();
        HttpApiConfig schemaChange = HttpApiConfig.builder().url(TestProvidedSchema.makeUrl("http://localhost:%d/json")).method("get").jsonOptions(jsonOptionsSchemaChange).requireTail(false).inputType("json").build();
        TupleMetadata partialMapSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addMap("field2").addNullable("nested_value1", TypeProtos.MinorType.VARCHAR).resumeSchema().buildSchema();
        HttpApiConfig partialSchema = HttpApiConfig.builder().url(TestProvidedSchema.makeUrl("http://localhost:%d/json")).method("get").jsonOptions(HttpJsonOptions.builder().schema(partialMapSchema).build()).requireTail(false).inputType("json").build();
        PrimitiveColumnMetadata jsonColumn = MetadataUtils.newScalar((String)"field2", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        jsonColumn.setProperty("drill.json-mode", "json");
        TupleMetadata jsonModeSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).add((ColumnMetadata)jsonColumn).build();
        HttpJsonOptions jsonModeOptions = HttpJsonOptions.builder().schema(jsonModeSchema).skipMalformedRecords(Boolean.valueOf(true)).build();
        HttpApiConfig jsonModeConfig = HttpApiConfig.builder().url(TestProvidedSchema.makeUrl("http://localhost:%d/json")).method("get").jsonOptions(jsonModeOptions).requireTail(false).inputType("json").build();
        HttpApiConfig noSchema = HttpApiConfig.builder().url(TestProvidedSchema.makeUrl("http://localhost:%d/json")).method("get").requireTail(false).inputType("json").build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("basicJson", basicJson);
        configs.put("schemaChange", schemaChange);
        configs.put("partialSchema", partialSchema);
        configs.put("jsonMode", jsonModeConfig);
        configs.put("noSchema", noSchema);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(2), Integer.valueOf(1000), "globaluser", "globalpass", "", Integer.valueOf(80), "", "", "", null, (CredentialsProvider)new PlainCredentialsProvider((Map)ImmutableMap.of((Object)"username", (Object)"globaluser", (Object)"password", (Object)"globalpass")), StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("local", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    @Test
    public void testProvidedSchema() throws Exception {
        String sql = "SELECT * FROM `local`.`basicJson`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("col_1", TypeProtos.MinorType.FLOAT8).addNullable("col_2", TypeProtos.MinorType.FLOAT8).addNullable("col_3", TypeProtos.MinorType.FLOAT8).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1.0, 2.0, 3.0}).addRow(new Object[]{4.0, 5.0, 6.0}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testSchemaChangeWithProvidedSchema() throws Exception {
        String sql = "SELECT * FROM `local`.`schemaChange`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_SCHEMA_CHANGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addMap("field2").addNullable("nested_value1", TypeProtos.MinorType.VARCHAR).addNullable("nested_value2", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"value1", RowSetUtilities.strArray((String[])new String[]{null, null})}).addRow(new Object[]{"value3", RowSetUtilities.strArray((String[])new String[]{"nv1", "nv2"})}).addRow(new Object[]{"value5", RowSetUtilities.strArray((String[])new String[]{"nv3", "nv4"})}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testPartialSchema() throws Exception {
        String sql = "SELECT * FROM `local`.`partialSchema`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_SCHEMA_CHANGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addMap("field2").addNullable("nested_value1", TypeProtos.MinorType.VARCHAR).addNullable("nested_value2", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"value1", RowSetUtilities.strArray((String[])new String[]{null, null})}).addRow(new Object[]{"value3", RowSetUtilities.strArray((String[])new String[]{"nv1", "nv2"})}).addRow(new Object[]{"value5", RowSetUtilities.strArray((String[])new String[]{"nv3", "nv4"})}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testInlineSchema() throws Exception {
        String sql = "SELECT * FROM table(`local`.`noSchema` (schema => 'inline=(`field1` VARCHAR, `field2` VARCHAR properties {`drill.json-mode` = `json`})'))";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_SCHEMA_CHANGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addNullable("field2", TypeProtos.MinorType.VARCHAR).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"value1", "value2"}).addRow(new Object[]{"value3", "{\"nested_value1\": nv1, \"nested_value2\": nv2}"}).addRow(new Object[]{"value5", "{\"nested_value1\": nv3, \"nested_value2\": nv4}"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testPartialJSONSchema() throws Exception {
        String sql = "SELECT * FROM `local`.`partialSchema`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_SCHEMA_CHANGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addMap("field2").addNullable("nested_value1", TypeProtos.MinorType.VARCHAR).addNullable("nested_value2", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"value1", RowSetUtilities.strArray((String[])new String[]{null, null})}).addRow(new Object[]{"value3", RowSetUtilities.strArray((String[])new String[]{"nv1", "nv2"})}).addRow(new Object[]{"value5", RowSetUtilities.strArray((String[])new String[]{"nv3", "nv4"})}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testJsonMode() throws Exception {
        String sql = "SELECT * FROM `local`.`jsonMode`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_SCHEMA_CHANGE1));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addNullable("field2", TypeProtos.MinorType.VARCHAR).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"value1", "value2"}).addRow(new Object[]{"value3", "{\"nested_value1\": nv1, \"nested_value2\": nv2}"}).addRow(new Object[]{"value5", "{\"nested_value1\": nv3, \"nested_value2\": nv4}"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    private MockWebServer startServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.start(47777);
        return server;
    }

    private static String makeUrl(String url) {
        return String.format(url, 47777);
    }
}

