/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import okhttp3.HttpUrl;
import org.apache.drill.exec.store.http.paginator.OffsetPaginator;
import org.apache.drill.exec.store.http.paginator.PagePaginator;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestPaginator {
    @Test
    public void TestOffsetPaginator() {
        String baseUrl = "https://myapi.com";
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)baseUrl).newBuilder();
        OffsetPaginator op = new OffsetPaginator(urlBuilder, 25, 5, "limit", "offset");
        for (int i = 0; i < 25; i += 5) {
            Assertions.assertEquals((Object)String.format("%s/?offset=%d&limit=5", baseUrl, i), (Object)op.next());
        }
        Assertions.assertFalse((boolean)op.hasNext());
    }

    @Test
    public void TestPagePaginatorIterator() {
        String baseUrl = "https://api.github.com/orgs/apache/repos";
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)baseUrl).newBuilder();
        PagePaginator pp = new PagePaginator(urlBuilder, 10, 2, "page", "per_page");
        for (int i = 1; i <= 5; ++i) {
            Assertions.assertEquals((Object)String.format("%s?page=%d&per_page=%d", baseUrl, i, 2), (Object)pp.next());
        }
        Assertions.assertFalse((boolean)pp.hasNext());
        PagePaginator pp2 = new PagePaginator(urlBuilder, 10, 100, "page", "per_page");
        Assertions.assertEquals((Object)String.format("%s?page=%d&per_page=%d", baseUrl, 1, 100), (Object)pp2.next());
        Assertions.assertFalse((boolean)pp.hasNext());
    }
}

