/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpStoragePlugin;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOAuthTokenUpdate
extends ClusterTest {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    private static final String CONNECTION_NAME = "localOauth";
    private static final int MOCK_SERVER_PORT = 47770;
    private static final int TIMEOUT = 30;
    private static String hostname;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();

    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true);
        TestOAuthTokenUpdate.startCluster((ClusterFixtureBuilder)builder);
        int portNumber = cluster.drillbit().getWebServerPort();
        hostname = "http://localhost:" + portNumber + "/storage/" + CONNECTION_NAME;
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("clientID", "12345");
        creds.put("clientSecret", "54321");
        creds.put("accessToken", null);
        creds.put("refreshToken", null);
        creds.put("tokenURI", "http://localhost:47770/get_access_token");
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(creds);
        HttpApiConfig connectionConfig = HttpApiConfig.builder().url("http://localhost:47770/getdata").method("get").requireTail(false).inputType("json").build();
        OAuthConfig oAuthConfig = OAuthConfig.builder().callbackURL(hostname + "/update_ouath2_authtoken").build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("test", connectionConfig);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(30), Integer.valueOf(1000), null, null, "", Integer.valueOf(80), "", "", "", oAuthConfig, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin(CONNECTION_NAME, (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    @Test
    public void testUpdateAccessToken() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"accessToken", (Object)"access_approved");
        RequestBody requestBody = RequestBody.create((String)jsonObject.toString(), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(hostname + "/update_access_token").post(requestBody).build();
        Call call = this.httpClient.newCall(request);
        Response response = call.execute();
        Assert.assertEquals((long)response.code(), (long)200L);
        PersistentTokenTable tokenTable = this.getTokenTable();
        Assert.assertEquals((Object)"access_approved", (Object)tokenTable.getAccessToken());
    }

    @Test
    public void testUpdateRefreshToken() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"refreshToken", (Object)"refresh_me");
        RequestBody requestBody = RequestBody.create((String)jsonObject.toString(), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(hostname + "/update_refresh_token").post(requestBody).build();
        Call call = this.httpClient.newCall(request);
        Response response = call.execute();
        Assert.assertEquals((long)response.code(), (long)200L);
        PersistentTokenTable tokenTable = this.getTokenTable();
        Assert.assertEquals((Object)tokenTable.getRefreshToken(), (Object)"refresh_me");
    }

    @Test
    public void testUpdateAllTokens() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"accessToken", (Object)"access_approved");
        jsonObject.put((Object)"refreshToken", (Object)"refresh_me");
        RequestBody requestBody = RequestBody.create((String)jsonObject.toString(), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(hostname + "/update_oauth_tokens").post(requestBody).build();
        Call call = this.httpClient.newCall(request);
        Response response = call.execute();
        Assert.assertEquals((long)response.code(), (long)200L);
        PersistentTokenTable tokenTable = this.getTokenTable();
        Assert.assertEquals((Object)tokenTable.getAccessToken(), (Object)"access_approved");
        Assert.assertEquals((Object)tokenTable.getRefreshToken(), (Object)"refresh_me");
    }

    private PersistentTokenTable getTokenTable() throws StoragePluginRegistry.PluginException {
        PersistentTokenTable tokenTable = ((HttpStoragePlugin)cluster.storageRegistry().getPlugin(CONNECTION_NAME)).getTokenRegistry().getTokenTable(CONNECTION_NAME);
        return tokenTable;
    }
}

