/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpStoragePlugin;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOAuthProcess
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(TestOAuthProcess.class);
    private static final int MOCK_SERVER_PORT = 47779;
    private static final int TIMEOUT = 30;
    private static final String CONNECTION_NAME = "localOauth";
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private static String ACCESS_TOKEN_RESPONSE;
    private static String REFRESH_TOKEN_RESPONSE;
    private static String TEST_JSON_RESPONSE_WITH_DATATYPES;
    private static String hostname;

    @BeforeClass
    public static void setup() throws Exception {
        ACCESS_TOKEN_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/oauth_access_token_response.json"), (Charset)Charsets.UTF_8).read();
        REFRESH_TOKEN_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/token_refresh.json"), (Charset)Charsets.UTF_8).read();
        TEST_JSON_RESPONSE_WITH_DATATYPES = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response2.json"), (Charset)Charsets.UTF_8).read();
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true);
        TestOAuthProcess.startCluster((ClusterFixtureBuilder)builder);
        int portNumber = cluster.drillbit().getWebServerPort();
        hostname = "http://localhost:" + portNumber + "/storage/" + CONNECTION_NAME;
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("clientID", "12345");
        creds.put("clientSecret", "54321");
        creds.put("accessToken", null);
        creds.put("refreshToken", null);
        creds.put("tokenURI", "http://localhost:47779/get_access_token");
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(creds);
        HttpApiConfig connectionConfig = HttpApiConfig.builder().url("http://localhost:47779/getdata").method("get").requireTail(false).inputType("json").build();
        OAuthConfig oAuthConfig = OAuthConfig.builder().callbackURL(hostname + "/update_oauth2_authtoken").build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("test", connectionConfig);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(30), Integer.valueOf(1000), null, null, "", Integer.valueOf(80), "", "", "", oAuthConfig, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin(CONNECTION_NAME, (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    @Test
    public void testAccessToken() {
        String url = hostname + "/update_oauth2_authtoken?code=ABCDEF";
        Request request = new Request.Builder().url(url).build();
        try (MockWebServer server = TestOAuthProcess.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(ACCESS_TOKEN_RESPONSE));
            Response response = this.httpClient.newCall(request).execute();
            Assert.assertEquals((long)200L, (long)response.code());
            PersistentTokenTable tokenTable = ((HttpStoragePlugin)cluster.storageRegistry().getPlugin(CONNECTION_NAME)).getTokenTable();
            Assert.assertEquals((Object)"you_have_access", (Object)tokenTable.getAccessToken());
            Assert.assertEquals((Object)"refresh_me", (Object)tokenTable.getRefreshToken());
            Assert.assertEquals((Object)"3600", (Object)tokenTable.getExpiresIn());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            Assert.fail();
        }
    }

    @Test
    public void testGetDataWithAuthentication() {
        String url = hostname + "/update_oauth2_authtoken?code=ABCDEF";
        Request request = new Request.Builder().url(url).build();
        try (MockWebServer server = TestOAuthProcess.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(ACCESS_TOKEN_RESPONSE));
            Response response = this.httpClient.newCall(request).execute();
            Assert.assertEquals((long)200L, (long)response.code());
            PersistentTokenTable tokenTable = ((HttpStoragePlugin)cluster.storageRegistry().getPlugin(CONNECTION_NAME)).getTokenRegistry().getTokenTable(CONNECTION_NAME);
            Assert.assertEquals((Object)"you_have_access", (Object)tokenTable.getAccessToken());
            Assert.assertEquals((Object)"refresh_me", (Object)tokenTable.getRefreshToken());
            Assert.assertEquals((Object)"3600", (Object)tokenTable.getExpiresIn());
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE_WITH_DATATYPES));
            String sql = "SELECT * FROM localOauth.test";
            DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("col_1", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).add("col_2", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("col_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1.0, 2, "3.0"}).addRow(new Object[]{4.0, 5, "6.0"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            Assert.fail();
        }
    }

    @Test
    public void testGetDataWithTokenRefresh() {
        String url = hostname + "/update_oauth2_authtoken?code=ABCDEF";
        Request request = new Request.Builder().url(url).build();
        try (MockWebServer server = TestOAuthProcess.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(ACCESS_TOKEN_RESPONSE));
            Response response = this.httpClient.newCall(request).execute();
            Assert.assertEquals((long)200L, (long)response.code());
            PersistentTokenTable tokenTable = ((HttpStoragePlugin)cluster.storageRegistry().getPlugin(CONNECTION_NAME)).getTokenRegistry().getTokenTable(CONNECTION_NAME);
            Assert.assertEquals((Object)"you_have_access", (Object)tokenTable.getAccessToken());
            Assert.assertEquals((Object)"refresh_me", (Object)tokenTable.getRefreshToken());
            Assert.assertEquals((Object)"3600", (Object)tokenTable.getExpiresIn());
            server.enqueue(new MockResponse().setResponseCode(401).setBody("Access Denied"));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(REFRESH_TOKEN_RESPONSE));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE_WITH_DATATYPES));
            String sql = "SELECT * FROM localOauth.test";
            DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
            Assert.assertEquals((Object)"token 2.0", (Object)tokenTable.getAccessToken());
            Assert.assertEquals((Object)"refresh 2.0", (Object)tokenTable.getRefreshToken());
            Assert.assertEquals((Object)"3800", (Object)tokenTable.getExpiresIn());
            TupleMetadata expectedSchema = new SchemaBuilder().add("col_1", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).add("col_2", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("col_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1.0, 2, "3.0"}).addRow(new Object[]{4.0, 5, "6.0"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            Assert.fail();
        }
    }

    public static MockWebServer startServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.start(47779);
        return server;
    }
}

