/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.typesafe.config.Config;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.store.http.util.HttpProxyConfig;
import org.apache.drill.test.ConfigBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestHttpProxy {
    @Test
    public void testBasics() {
        HttpProxyConfig proxy = HttpProxyConfig.builder().type("socks").host(" foo.com ").port(1234).username(" bob ").password(" secret ").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.SOCKS, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testURL() {
        HttpProxyConfig proxy = HttpProxyConfig.builder().url("http://bob:secret@foo.com:1234").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.HTTP, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testURLAndConfig() {
        HttpProxyConfig proxy = HttpProxyConfig.builder().url("http://foo.com:1234").username("bob").password("secret").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.HTTP, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testNone() {
        HttpProxyConfig proxy = HttpProxyConfig.builder().type("").host("foo.com").port(1234).username("bob").password("secret").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.NONE, (Object)proxy.type);
        Assert.assertNull((Object)proxy.host);
        Assert.assertNull((Object)proxy.username);
        Assert.assertNull((Object)proxy.password);
    }

    @Test
    public void testBlankType() {
        HttpProxyConfig proxy = HttpProxyConfig.builder().type("  ").host("foo.com").port(1234).username("bob").password("secret").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.NONE, (Object)proxy.type);
        Assert.assertNull((Object)proxy.host);
        Assert.assertNull((Object)proxy.username);
        Assert.assertNull((Object)proxy.password);
    }

    @Test
    public void testBadType() {
        HttpProxyConfig proxy = HttpProxyConfig.builder().type("bogus").host("foo.com").port(1234).username("bob").password("secret").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.NONE, (Object)proxy.type);
        Assert.assertNull((Object)proxy.host);
        Assert.assertNull((Object)proxy.username);
        Assert.assertNull((Object)proxy.password);
    }

    @Test
    public void testHttpConfig() {
        DrillConfig config = new ConfigBuilder().put("drill.exec.net_proxy.http_url", (Object)"http://bob:secret@foo.com:1234").build();
        HttpProxyConfig proxy = HttpProxyConfig.builder().fromHttpConfig((Config)config).build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.HTTP, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testHttpUrlConfig() {
        DrillConfig config = new ConfigBuilder().put("drill.exec.net_proxy.http_url", (Object)"").put("drill.exec.net_proxy.http.type", (Object)"socks").put("drill.exec.net_proxy.http.host", (Object)"foo.com").put("drill.exec.net_proxy.http.port", (Object)1234).put("drill.exec.net_proxy.http.user_name", (Object)"bob").put("drill.exec.net_proxy.http.password", (Object)"secret").build();
        HttpProxyConfig proxy = HttpProxyConfig.builder().fromHttpConfig((Config)config).build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.SOCKS, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testHttpsUrlConfig() {
        DrillConfig config = new ConfigBuilder().put("drill.exec.net_proxy.https_url", (Object)"https://bob:secret@foo.com:1234").build();
        HttpProxyConfig proxy = HttpProxyConfig.builder().fromHttpsConfig((Config)config).build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.HTTP, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testHttpsConfig() {
        DrillConfig config = new ConfigBuilder().put("drill.exec.net_proxy.https_url", (Object)"").put("drill.exec.net_proxy.https.type", (Object)"socks").put("drill.exec.net_proxy.https.host", (Object)"foo.com").put("drill.exec.net_proxy.https.port", (Object)1234).put("drill.exec.net_proxy.https.user_name", (Object)"bob").put("drill.exec.net_proxy.https.password", (Object)"secret").build();
        HttpProxyConfig proxy = HttpProxyConfig.builder().fromHttpsConfig((Config)config).build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.SOCKS, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
    }

    @Test
    public void testConfigForUrl() {
        DrillConfig config = new ConfigBuilder().put("drill.exec.net_proxy.http_url", (Object)"http://bob:secret@foo.com:1234").put("drill.exec.net_proxy.https_url", (Object)"http://alice:s3cr3t@bar.com:2345").build();
        this.doTestConfigForUrl((Config)config);
    }

    private void doTestConfigForUrl(Config config) {
        HttpProxyConfig proxy = HttpProxyConfig.builder().fromConfigForURL(config, "http://google.com").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.HTTP, (Object)proxy.type);
        Assert.assertEquals((Object)"foo.com", (Object)proxy.host);
        Assert.assertEquals((long)1234L, (long)proxy.port);
        Assert.assertEquals((Object)"bob", (Object)proxy.username);
        Assert.assertEquals((Object)"secret", (Object)proxy.password);
        proxy = HttpProxyConfig.builder().fromConfigForURL(config, "https://google.com").build();
        Assert.assertEquals((Object)HttpProxyConfig.ProxyType.HTTP, (Object)proxy.type);
        Assert.assertEquals((Object)"bar.com", (Object)proxy.host);
        Assert.assertEquals((long)2345L, (long)proxy.port);
        Assert.assertEquals((Object)"alice", (Object)proxy.username);
        Assert.assertEquals((Object)"s3cr3t", (Object)proxy.password);
    }

    @Test
    @Ignore(value="Requires manual setup")
    public void testEnvVar() {
        DrillConfig config = new ConfigBuilder().build();
        this.doTestConfigForUrl((Config)config);
    }
}

