/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpJsonOptions;
import org.apache.drill.exec.store.http.HttpPaginatorConfig;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.exec.store.http.HttpXmlOptions;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestHttpPlugin
extends ClusterTest {
    private static final int MOCK_SERVER_PORT = 44332;
    private static String TEST_JSON_RESPONSE;
    private static String TEST_MALFORMED_JSON_RESPONSE;
    private static String TEST_CSV_RESPONSE;
    private static String TEST_XML_RESPONSE;
    private static String TEST_JSON_RESPONSE_WITH_DATATYPES;

    public static String makeUrl(String url) {
        return String.format(url, 44332);
    }

    @BeforeClass
    public static void setup() throws Exception {
        TestHttpPlugin.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TEST_JSON_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response.json"), (Charset)Charsets.UTF_8).read();
        TEST_MALFORMED_JSON_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/malformed.json"), (Charset)Charsets.UTF_8).read();
        TEST_CSV_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response.csv"), (Charset)Charsets.UTF_8).read();
        TEST_XML_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response.xml"), (Charset)Charsets.UTF_8).read();
        TEST_JSON_RESPONSE_WITH_DATATYPES = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response2.json"), (Charset)Charsets.UTF_8).read();
        dirTestWatcher.copyResourceToRoot(Paths.get("data/", new String[0]));
        TestHttpPlugin.makeLiveConfig();
        TestHttpPlugin.makeMockConfig();
    }

    private static void makeLiveConfig() {
        HttpApiConfig sunriseConfig = HttpApiConfig.builder().url("https://api.sunrise-sunset.org/json").method("GET").build();
        HttpApiConfig sunriseWithParamsConfig = HttpApiConfig.builder().url("https://api.sunrise-sunset.org/json").method("GET").params(Arrays.asList("lat", "lng", "date")).dataPath("results").requireTail(false).build();
        HttpApiConfig stockConfig = HttpApiConfig.builder().url("https://api.worldtradingdata.com/api/v1/stock?symbol=SNAP,TWTR,VOD.L&api_token=zuHlu2vZaehdZN6GmJdTiVlp7xgZn6gl6sfgmI4G6TY4ej0NLOzvy0TUl4D4").method("get").build();
        HttpApiConfig pokemonConfig = HttpApiConfig.builder().url("https://pokeapi.co/api/v2/pokemon/{pokemon_name}").method("get").inputType("json").requireTail(false).build();
        HttpXmlOptions nycXmlOptions = HttpXmlOptions.builder().dataLevel(5).build();
        HttpApiConfig nycConfig = HttpApiConfig.builder().url("https://www.checkbooknyc.com/api").method("post").inputType("xml").requireTail(false).params(Arrays.asList("type_of_data", "records_from", "max_records")).postParameterLocation("xml_body").xmlOptions(nycXmlOptions).build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("stock", stockConfig);
        configs.put("sunrise", sunriseConfig);
        configs.put("sunrise2", sunriseWithParamsConfig);
        configs.put("pokemon", pokemonConfig);
        configs.put("nyc", nycConfig);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(10), Integer.valueOf(1000), null, null, "", Integer.valueOf(80), "", "", "", null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER, StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("live", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    private static void makeMockConfig() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header1", "value1");
        headers.put("header2", "value2");
        HttpApiConfig mockSchema = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/json")).method("GET").headers(headers).authType("basic").credentialsProvider((CredentialsProvider)new PlainCredentialsProvider((Map)ImmutableMap.of((Object)"username", (Object)"user", (Object)"password", (Object)"pass"))).dataPath("results").errorOn400(true).build();
        HttpApiConfig mockTable = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/json")).method("GET").headers(headers).authType("basic").userName("user").password("pass").params(Arrays.asList("lat", "lng", "date")).dataPath("results").requireTail(false).build();
        HttpApiConfig mockPostConfig = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/")).method("POST").headers(headers).postBody("key1=value1\nkey2=value2").build();
        HttpApiConfig mockPostPushdownWithStaticParams = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/")).method("POST").headers(headers).requireTail(false).params(Arrays.asList("lat", "lng", "date")).postBody("key1=value1\nkey2=value2").postParameterLocation("post_body").build();
        HttpApiConfig mockPostPushdown = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/")).method("POST").headers(headers).requireTail(false).params(Arrays.asList("lat", "lng", "date")).postParameterLocation("post_body").build();
        HttpApiConfig mockJsonNullBodyPost = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/")).method("POST").headers(headers).requireTail(false).params(Arrays.asList("lat", "lng", "date")).postParameterLocation("json_body").build();
        HttpApiConfig mockJsonPostConfig = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/")).method("POST").headers(headers).requireTail(false).params(Arrays.asList("lat", "lng", "date")).postParameterLocation("json_body").postBody("key1=value1\nkey2=value2").build();
        HttpPaginatorConfig offsetPaginatorForJson = HttpPaginatorConfig.builder().limitParam("limit").offsetParam("offset").method("offset").pageSize(2).build();
        HttpApiConfig mockJsonConfigWithPaginator = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/json")).method("get").headers(headers).requireTail(false).paginator(offsetPaginatorForJson).inputType("json").build();
        HttpApiConfig mockJsonWithMalformedData = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/json")).method("get").requireTail(false).jsonOptions(new HttpJsonOptions.HttpJsonOptionsBuilder().skipMalformedRecords(Boolean.valueOf(true)).build()).inputType("json").build();
        HttpApiConfig mockPostConfigWithoutPostBody = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/")).method("POST").authType("basic").headers(headers).build();
        HttpApiConfig mockCsvConfig = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/csv")).method("GET").headers(headers).authType("basic").userName("user").password("pass").dataPath("results").inputType("csv").build();
        HttpApiConfig mockCsvConfigWithPaginator = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/csv")).method("get").paginator(offsetPaginatorForJson).inputType("csv").requireTail(false).dataPath("results").build();
        HttpXmlOptions xmlOptions = new HttpXmlOptions.HttpXmlOptionsBuilder().dataLevel(2).build();
        TupleMetadata testSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP).addNullable("COMMON", TypeProtos.MinorType.VARCHAR).addNullable("BOTANICAL", TypeProtos.MinorType.VARCHAR).addNullable("ZONE", TypeProtos.MinorType.INT).addNullable("LIGHT", TypeProtos.MinorType.VARCHAR).addNullable("PRICE", TypeProtos.MinorType.VARCHAR).addNullable("AVAILABILITY", TypeProtos.MinorType.VARCHAR).buildSchema();
        HttpXmlOptions xmlOptionsWithSchhema = new HttpXmlOptions.HttpXmlOptionsBuilder().dataLevel(2).schema(testSchema).build();
        HttpApiConfig mockXmlConfig = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/xml")).method("GET").headers(headers).authType("basic").userName("user").password("pass").dataPath("results").inputType("xml").xmlOptions(xmlOptions).build();
        HttpApiConfig mockXmlConfigWithSchema = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/xml")).method("GET").headers(headers).authType("basic").userName("user").password("pass").dataPath("results").inputType("xml").xmlOptions(xmlOptionsWithSchhema).build();
        HttpApiConfig mockGithubWithParam = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/orgs/{org}/repos")).method("GET").headers(headers).params(Arrays.asList("lat", "lng", "date")).dataPath("results").requireTail(false).build();
        HttpApiConfig mockGithubWithDuplicateParam = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/orgs/{org}/repos")).method("GET").headers(headers).params(Arrays.asList("org", "lng", "date")).dataPath("results").requireTail(false).build();
        HttpApiConfig mockGithubWithParamInQuery = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/orgs/{org}/repos?p1={p1}")).method("GET").headers(headers).params(Arrays.asList("p2", "p3")).dataPath("results").requireTail(false).build();
        HttpApiConfig mockTableWithJsonOptions = HttpApiConfig.builder().url(TestHttpPlugin.makeUrl("http://localhost:%d/json")).method("GET").headers(headers).requireTail(false).jsonOptions(HttpJsonOptions.builder().allTextMode(Boolean.valueOf(true)).build()).build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("csv_paginator", mockCsvConfigWithPaginator);
        configs.put("json_paginator", mockJsonConfigWithPaginator);
        configs.put("sunrise", mockSchema);
        configs.put("mocktable", mockTable);
        configs.put("mockpost", mockPostConfig);
        configs.put("nullPost", mockPostConfigWithoutPostBody);
        configs.put("mockJsonPost", mockJsonPostConfig);
        configs.put("mockJsonNullBodyPost", mockJsonNullBodyPost);
        configs.put("mockPostPushdown", mockPostPushdown);
        configs.put("mockPostPushdownWithStaticParams", mockPostPushdownWithStaticParams);
        configs.put("mockcsv", mockCsvConfig);
        configs.put("mockxml", mockXmlConfig);
        configs.put("mockxml_with_schema", mockXmlConfigWithSchema);
        configs.put("github", mockGithubWithParam);
        configs.put("github2", mockGithubWithDuplicateParam);
        configs.put("github3", mockGithubWithParamInQuery);
        configs.put("mockJsonAllText", mockTableWithJsonOptions);
        configs.put("malformedJson", mockJsonWithMalformedData);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(2), Integer.valueOf(1000), "globaluser", "globalpass", "", Integer.valueOf(80), "", "", "", null, (CredentialsProvider)new PlainCredentialsProvider((Map)ImmutableMap.of((Object)"username", (Object)"globaluser", (Object)"password", (Object)"globalpass")), StoragePluginConfig.AuthMode.SHARED_USER.name());
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("local", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    @Test
    public void verifyPluginConfig() throws Exception {
        String sql = "SELECT SCHEMA_NAME, TYPE FROM INFORMATION_SCHEMA.`SCHEMATA` WHERE TYPE='http'\nORDER BY SCHEMA_NAME";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("SCHEMA_NAME", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("TYPE", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"live", "http"}).addRow(new Object[]{"live.stock", "http"}).addRow(new Object[]{"live.sunrise", "http"}).addRow(new Object[]{"local", "http"}).addRow(new Object[]{"local.mockcsv", "http"}).addRow(new Object[]{"local.mockpost", "http"}).addRow(new Object[]{"local.mockxml", "http"}).addRow(new Object[]{"local.mockxml_with_schema", "http"}).addRow(new Object[]{"local.nullpost", "http"}).addRow(new Object[]{"local.sunrise", "http"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void simpleStarQuery() throws Exception {
        String sql = "SELECT * FROM live.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:12:17 AM", "6:01:54 PM", "12:07:06 PM", "11:49:37", "5:47:49 AM", "6:26:22 PM", "5:17:51 AM", "6:56:21 PM", "4:47:41 AM", "7:26:31 PM"}), "OK"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void wildcardQueryWithParams() throws Exception {
        String sql = "SELECT * FROM live.sunrise2\nWHERE `lat`=36.7201600 AND `lng`=-4.4203400 AND `date`='2019-10-02'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"6:12:17 AM", "6:01:54 PM", "12:07:06 PM", "11:49:37", "5:47:49 AM", "6:26:22 PM", "5:17:51 AM", "6:56:21 PM", "4:47:41 AM", "7:26:31 PM"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void simpleSpecificQuery() throws Exception {
        String sql = "SELECT t1.results.sunrise AS sunrise, t1.results.sunset AS sunset\nFROM live.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02` AS t1";
        this.doSimpleSpecificQuery(sql);
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void simpleSpecificQueryWithParams() throws Exception {
        String sql = "SELECT sunrise, sunset\nFROM live.sunrise2\nWHERE `lat`=36.7201600 AND `lng`=-4.4203400 AND `date`='2019-10-02'";
        this.doSimpleSpecificQuery(sql);
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void simpleStarQueryWithXMLParams() throws Exception {
        String sql = "SELECT year, department, expense_category, budget_code, budget_name, modified, adopted FROM live.nyc WHERE type_of_data='Budget' AND records_from=1 AND max_records=5 AND year IS NOT null";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("year", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("department", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("expense_category", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("budget_code", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("budget_name", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("modified", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("adopted", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"2022", "MEDICAL ASSISTANCE - OTPS", "MEDICAL ASSISTANCE", "9564", "MMIS MEDICAL ASSISTANCE", "5972433142", "5584533142"}).addRow(new Object[]{"2020", "MEDICAL ASSISTANCE - OTPS", "MEDICAL ASSISTANCE", "9564", "MMIS MEDICAL ASSISTANCE", "5819588142", "4953233142"}).addRow(new Object[]{"2014", "MEDICAL ASSISTANCE - OTPS", "MEDICAL ASSISTANCE", "9564", "MMIS MEDICAL ASSISTANCE", "5708101276", "5231324567"}).addRow(new Object[]{"2015", "MEDICAL ASSISTANCE - OTPS", "MEDICAL ASSISTANCE", "9564", "MMIS MEDICAL ASSISTANCE", "5663673673", "5312507361"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    private void doSimpleSpecificQuery(String sql) throws Exception {
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"6:12:17 AM", "6:01:54 PM"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void liveTestWithURLParameters() throws Exception {
        String sql = "SELECT * FROM live.pokemon WHERE pokemon_name = 'ditto'";
        client.testBuilder().sqlQuery(sql).expectsNumRecords(1).go();
    }

    @Test
    public void simpleTestWithJsonConfig() {
        String sql = "SELECT * FROM local.mockJsonAllText";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE_WITH_DATATYPES));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("col_1", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("col_2", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("col_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"1.0", "2", "3.0"}).addRow(new Object[]{"4.0", "5", "6.0"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void simpleTestWithMalformedJson() {
        String sql = "SELECT * FROM local.malformedJson";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_MALFORMED_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("a", TypeProtos.MinorType.BIGINT).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1}).addRow(new Object[]{5}).addRow(new Object[]{6}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void simpleTestWithMockServerWithURLParams() throws Exception {
        String sql = "SELECT _response_url FROM local.github\nWHERE `org` = 'apache'";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{TestHttpPlugin.makeUrl("http://localhost:%d/orgs/apache/repos")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void simpleTestWithMockServerWithURLParamsOfBooleanType() throws Exception {
        String sql = "SELECT _response_url FROM local.github\nWHERE `org` = true";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{TestHttpPlugin.makeUrl("http://localhost:%d/orgs/true/repos")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void simpleTestWithMockServerWithURLParamsOfIntType() throws Exception {
        String sql = "SELECT _response_url FROM local.github\nWHERE `org` = 1234";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{TestHttpPlugin.makeUrl("http://localhost:%d/orgs/1234/repos")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    @Ignore(value="Requires Remote Server")
    public void simpleTestWithUrlParamsInSubquery() throws Exception {
        String sql = "select pokemon_data.data.game_index AS game_index, pokemon_data.data.version.name AS name from (select flatten(game_indices) as data from live.pokemon where pokemon_name='ditto' ) as pokemon_data WHERE pokemon_data.data.game_index=76";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("game_index", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("name", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{76, "red"}).addRow(new Object[]{76, "blue"}).addRow(new Object[]{76, "yellow"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void simpleTestWithMockServerWithDuplicateURLParams() throws Exception {
        String sql = "SELECT _response_url FROM local.github2\nWHERE `org` = 'apache'";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{TestHttpPlugin.makeUrl("http://localhost:%d/orgs/apache/repos?org=apache")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testUrlParamsInQueryString() throws Exception {
        String sql = "SELECT _response_url FROM local.github3\nWHERE `org` = 'apache' AND p1='param1' AND p2='param2'";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{TestHttpPlugin.makeUrl("http://localhost:%d/orgs/apache/repos?p1=param1&p2=param2")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testUrlParamError() throws Exception {
        String sql = "SELECT _response_url FROM local.github\n";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            TestHttpPlugin.run((String)sql, (Object[])new Object[0]);
            Assert.fail();
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("API Query with URL Parameters must be populated."));
        }
    }

    @Test
    public void testSerDeXML() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_RESPONSE));
            String sql = "SELECT COUNT(*) FROM local.mockxml.`xml?arg1=4` ";
            String plan = this.queryBuilder().sql(sql).explainJson();
            long cnt = this.queryBuilder().physical(plan).singletonLong();
            Assert.assertEquals((String)"Counts should match", (long)36L, (long)cnt);
        }
    }

    @Test
    public void testSerDeCSV() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE));
            String sql = "SELECT COUNT(*) FROM local.mockcsv.`csv?arg1=4` ";
            String plan = this.queryBuilder().sql(sql).explainJson();
            long cnt = this.queryBuilder().physical(plan).singletonLong();
            Assert.assertEquals((String)"Counts should match", (long)2L, (long)cnt);
        }
    }

    @Test
    public void testSerDe() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT COUNT(*) FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            String plan = this.queryBuilder().sql(sql).explainJson();
            long cnt = this.queryBuilder().physical(plan).singletonLong();
            Assert.assertEquals((String)"Counts should match", (long)1L, (long)cnt);
        }
    }

    @Test
    public void testApiConfigRequiresTailSerDe() throws Exception {
        String sql = "SELECT * FROM local.mocktable";
        this.queryBuilder().sql(sql).detailedPlanMatcher().include(new String[]{"requireTail=false"}).match();
    }

    @Test
    public void simpleTestWithMockServer() throws Exception {
        String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
        this.doSimpleTestWithMockServer(sql);
    }

    @Test
    public void simpleTestWithMockServerWithParams() throws Exception {
        String sql = "SELECT * FROM local.mocktable\nWHERE `lat` = 36.7201600 AND `lng` = -4.4203400 AND `date` = '2019-10-02'";
        this.doSimpleTestWithMockServer(sql);
    }

    @Test
    public void testCsvResponse() throws Exception {
        String sql = "SELECT * FROM local.mockcsv.`csv?arg1=4`";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("col1", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("col2", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("col3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"1", "2", "3"}).addRow(new Object[]{"4", "5", "6"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertNotNull((Object)recordedRequest.getHeader("Authorization"));
            Assert.assertEquals((Object)"Basic dXNlcjpwYXNz", (Object)recordedRequest.getHeader("Authorization"));
        }
    }

    @Test
    public void testXmlResponse() throws Exception {
        String sql = "SELECT * FROM local.mockxml.`?arg1=4` LIMIT 5";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP).addNullable("COMMON", TypeProtos.MinorType.VARCHAR).addNullable("BOTANICAL", TypeProtos.MinorType.VARCHAR).addNullable("ZONE", TypeProtos.MinorType.VARCHAR).addNullable("LIGHT", TypeProtos.MinorType.VARCHAR).addNullable("PRICE", TypeProtos.MinorType.VARCHAR).addNullable("AVAILABILITY", TypeProtos.MinorType.VARCHAR).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Bloodroot", "Sanguinaria canadensis", "4", "Mostly Shady", "$2.44", "031599"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Columbine", "Aquilegia canadensis", "3", "Mostly Shady", "$9.37", "030699"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Marsh Marigold", "Caltha palustris", "4", "Mostly Sunny", "$6.81", "051799"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Cowslip", "Caltha palustris", "4", "Mostly Shady", "$9.90", "030699"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Dutchman's-Breeches", "Dicentra cucullaria", "3", "Mostly Shady", "$6.44", "012099"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testXmlWithSchemaResponse() throws Exception {
        String sql = "SELECT * FROM local.mockxml_with_schema.`?arg1=4` LIMIT 5";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP).addNullable("COMMON", TypeProtos.MinorType.VARCHAR).addNullable("BOTANICAL", TypeProtos.MinorType.VARCHAR).addNullable("ZONE", TypeProtos.MinorType.INT).addNullable("LIGHT", TypeProtos.MinorType.VARCHAR).addNullable("PRICE", TypeProtos.MinorType.VARCHAR).addNullable("AVAILABILITY", TypeProtos.MinorType.VARCHAR).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Bloodroot", "Sanguinaria canadensis", 4, "Mostly Shady", "$2.44", "031599"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Columbine", "Aquilegia canadensis", 3, "Mostly Shady", "$9.37", "030699"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Marsh Marigold", "Caltha palustris", 4, "Mostly Sunny", "$6.81", "051799"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Cowslip", "Caltha palustris", 4, "Mostly Shady", "$9.90", "030699"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "Dutchman's-Breeches", "Dicentra cucullaria", 3, "Mostly Shady", "$6.44", "012099"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testImplicitFieldsWithJSON() throws Exception {
        String sql = "SELECT _response_code, _response_message, _response_protocol, _response_url FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_code", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("_response_message", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_protocol", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/json?lat=36.7201600&lng=-4.4203400&date=2019-10-02")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testImplicitFieldsWithCSV() throws Exception {
        String sql = "SELECT _response_code, _response_message, _response_protocol, _response_url FROM local.mockcsv.`csv?arg1=4`";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_code", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("_response_message", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_protocol", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/csvcsv?arg1=4")}).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/csvcsv?arg1=4")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testImplicitFieldsWithXML() throws Exception {
        String sql = "SELECT _response_code, _response_message, _response_protocol, _response_url FROM local.mockxml.`?arg1=4` LIMIT 5";
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_code", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("_response_message", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_protocol", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/xml?arg1=4")}).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/xml?arg1=4")}).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/xml?arg1=4")}).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/xml?arg1=4")}).addRow(new Object[]{200, "OK", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/xml?arg1=4")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    private void doSimpleTestWithMockServer(String sql) throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testPostWithMockServerAndNullPostbody() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.nullPost\n.`json?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            Assert.assertNotNull((Object)recordedRequest.getHeader("Authorization"));
            Assert.assertEquals((Object)"Basic Z2xvYmFsdXNlcjpnbG9iYWxwYXNz", (Object)recordedRequest.getHeader("Authorization"));
        }
    }

    @Test
    public void testPostWithMockServer() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.mockPost.`json?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            Assert.assertEquals((Object)recordedRequest.getHeader("header1"), (Object)"value1");
            Assert.assertEquals((Object)recordedRequest.getHeader("header2"), (Object)"value2");
        }
    }

    @Test
    public void specificTestWithMockServer() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT sunrise, sunset FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02` AS t1";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"6:13:58 AM", "5:59:55 PM"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "SELECT sunrise, sunset FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02` AS t1 LIMIT 5";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=5"}).match();
    }

    @Test
    public void testLimitPushdownWithFilter() throws Exception {
        String sql = "SELECT sunrise, sunset FROM live.sunrise2 WHERE `date`='2019-10-02' LIMIT 5";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=5", "filters=\\{date=2019-10-02\\}"}).match();
    }

    @Test
    public void testSlowResponse() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE).setBodyDelay(6L, TimeUnit.SECONDS));
            String sql = "SELECT sunrise AS sunrise, sunset AS sunset FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02` AS t1";
            try {
                client.queryBuilder().sql(sql).rowSet();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Not timeout exception, " + e), (e.getMessage().contains("DATA_READ ERROR: timeout") || e.getMessage().contains("DATA_READ ERROR: Read timed out") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testZeroByteResponse() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(""));
            String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertNull((Object)results);
        }
    }

    @Test
    public void testZeroByteResponseFromCSV() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(""));
            String sql = "SELECT * FROM local.mockcsv.`csv?arg1=4`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertNull((Object)results);
        }
    }

    @Test
    public void testEmptyJSONObjectResponse() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody("{}"));
            String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertNull((Object)results);
        }
    }

    @Test
    public void testNullContent() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody("{results: null}"));
            String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            Assert.assertNull((Object)results);
        }
    }

    @Test
    public void testEmptyContent() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody("{results: {} }"));
            String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[0]).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testErrorResponse() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(404).setBody("{}"));
            String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            try {
                client.queryBuilder().sql(sql).rowSet();
                Assert.fail();
            }
            catch (Exception e) {
                String msg = e.getMessage();
                Assert.assertTrue((boolean)msg.contains("DATA_READ ERROR: HTTP request failed"));
                Assert.assertTrue((boolean)msg.contains("Response code: 404"));
                Assert.assertTrue((boolean)msg.contains("Response message: Client Error"));
                Assert.assertTrue((boolean)msg.contains("Connection: sunrise"));
                Assert.assertTrue((boolean)msg.contains("Plugin: local"));
            }
        }
    }

    @Test
    public void testNoErrorOn404() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(404).setBody("{}"));
            String sql = "SELECT _response_code, _response_message, _response_protocol, _response_url FROM local.mocktable";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("_response_code", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("_response_message", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_protocol", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("_response_url", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{404, "Client Error", "http/1.1", TestHttpPlugin.makeUrl("http://localhost:%d/json")}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
    }

    @Test
    public void testHeaders() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.sunrise.`?lat=36.7201600&lng=-4.4203400&date=2019-10-02`";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((Object)"value1", (Object)request.getHeader("header1"));
            Assert.assertEquals((Object)"value2", (Object)request.getHeader("header2"));
            Assert.assertEquals((Object)"Basic dXNlcjpwYXNz", (Object)request.getHeader("Authorization"));
        }
    }

    @Test
    public void testJsonPostWithMockServer() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.mockJsonPost";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            String resultJsonString = recordedRequest.getBody().toString();
            Assert.assertEquals((Object)"[text={\"key1\":\"value1\",\"key2\":\"value2\"}]", (Object)resultJsonString);
        }
    }

    @Test
    public void testJsonPostWithFiltersAndMockServer() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.mockJsonPost WHERE lat=36.7201600 AND lng=-4.4203400";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            String resultJsonString = recordedRequest.getBody().toString();
            Assert.assertEquals((Object)"[size=71 text={\"key1\":\"value1\",\"key2\":\"value2\",\"lng\":\"-4.4203400\",\"lat\":\"36.72\u2026]", (Object)resultJsonString);
        }
    }

    @Test
    public void testJsonPostWithFiltersAndNullPostBodyMockServer() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.mockJsonNullBodyPost WHERE lat=36.7201600 AND lng=-4.4203400";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            String resultJsonString = recordedRequest.getBody().toString();
            Assert.assertEquals((Object)"[text={\"lng\":\"-4.4203400\",\"lat\":\"36.7201600\"}]", (Object)resultJsonString);
        }
    }

    @Test
    public void testParamsInPostBody() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.mockPostPushdown WHERE lat=36.7201600 AND lng=-4.4203400";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            String resultJsonString = recordedRequest.getBody().toString();
            Assert.assertEquals((Object)"[text=lng=-4.4203400&lat=36.7201600]", (Object)resultJsonString);
        }
    }

    @Test
    public void testParamsInPostBodyAndStaticParams() throws Exception {
        try (MockWebServer server = TestHttpPlugin.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_RESPONSE));
            String sql = "SELECT * FROM local.mockPostPushdownWithStaticParams WHERE lat=36.7201600 AND lng=-4.4203400";
            DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addMap("results").add("sunrise", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("sunset", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("solar_noon", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("day_length", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("civil_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("nautical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_begin", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("astronomical_twilight_end", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).resumeSchema().add("status", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{RowSetUtilities.mapValue((Object[])new Object[]{"6:13:58 AM", "5:59:55 PM", "12:06:56 PM", "11:45:57", "5:48:14 AM", "6:25:38 PM", "5:18:16 AM", "6:55:36 PM", "4:48:07 AM", "7:25:45 PM"}), "OK"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
            RecordedRequest recordedRequest = server.takeRequest();
            Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
            String resultJsonString = recordedRequest.getBody().toString();
            Assert.assertEquals((Object)"[text=key1=value1&key2=value2&lng=-4.4203400&lat=36.7201600]", (Object)resultJsonString);
        }
    }

    public static MockWebServer startServer() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.start(44332);
        return server;
    }
}

