/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import java.util.Map;
import okhttp3.HttpUrl;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.store.http.util.SimpleHttp;
import org.junit.Assert;
import org.junit.Test;

public class TestURLParameters {
    @Test
    public void testUrlParameters() {
        HttpUrl githubSingleParam = HttpUrl.parse((String)"https://github.com/orgs/{org}/repos");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        filters.put("org", (Object)"apache");
        filters.put("param1", (Object)"value1");
        filters.put("param2", (Object)"value2");
        Assert.assertEquals((Object)"https://github.com/orgs/apache/repos", (Object)SimpleHttp.mapURLParameters((HttpUrl)githubSingleParam, (Map)filters));
        HttpUrl githubMultiParam = HttpUrl.parse((String)"https://github.com/orgs/{org}/{repos}");
        CaseInsensitiveMap filters2 = CaseInsensitiveMap.newHashMap();
        filters2.put("org", (Object)"apache");
        filters2.put("param1", (Object)"value1");
        filters2.put("repos", (Object)"drill");
        Assert.assertEquals((Object)"https://github.com/orgs/apache/drill", (Object)SimpleHttp.mapURLParameters((HttpUrl)githubMultiParam, (Map)filters2));
        HttpUrl githubNoParam = HttpUrl.parse((String)"https://github.com/orgs/org/repos");
        CaseInsensitiveMap filters3 = CaseInsensitiveMap.newHashMap();
        filters3.put("org", (Object)"apache");
        filters3.put("param1", (Object)"value1");
        filters3.put("repos", (Object)"drill");
        Assert.assertEquals((Object)"https://github.com/orgs/org/repos", (Object)SimpleHttp.mapURLParameters((HttpUrl)githubNoParam, (Map)filters3));
    }

    @Test
    public void testParamAtEnd() {
        HttpUrl pokemonUrl = HttpUrl.parse((String)"https://pokeapi.co/api/v2/pokemon/{pokemon_name}");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        filters.put("pokemon_name", (Object)"Misty");
        filters.put("param1", (Object)"value1");
        filters.put("repos", (Object)"drill");
        Assert.assertEquals((Object)"https://pokeapi.co/api/v2/pokemon/Misty", (Object)SimpleHttp.mapURLParameters((HttpUrl)pokemonUrl, (Map)filters));
    }

    @Test
    public void testUpperCase() {
        HttpUrl githubSingleParam = HttpUrl.parse((String)"https://github.com/orgs/{ORG}/repos");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        filters.put("org", (Object)"apache");
        filters.put("param1", (Object)"value1");
        filters.put("param2", (Object)"value2");
        Assert.assertEquals((Object)"https://github.com/orgs/apache/repos", (Object)SimpleHttp.mapURLParameters((HttpUrl)githubSingleParam, (Map)filters));
    }

    @Test
    public void testURLDefaultParameters() {
        HttpUrl githubSingleParam = HttpUrl.parse((String)"https://github.com/orgs/{org=apache}/repos");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        filters.put("param1", (Object)"value1");
        filters.put("param2", (Object)"value2");
        Assert.assertEquals((Object)"https://github.com/orgs/apache/repos", (Object)SimpleHttp.mapURLParameters((HttpUrl)githubSingleParam, (Map)filters));
    }

    @Test
    public void testMixedCase() {
        HttpUrl githubSingleParam = HttpUrl.parse((String)"https://github.com/orgs/{ORG}/{org}/repos");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        filters.put("org", (Object)"apache");
        filters.put("ORG", (Object)"linux");
        filters.put("param1", (Object)"value1");
        filters.put("param2", (Object)"value2");
        Assert.assertEquals((Object)"https://github.com/orgs/linux/linux/repos", (Object)SimpleHttp.mapURLParameters((HttpUrl)githubSingleParam, (Map)filters));
    }

    @Test
    public void testDuplicateParameters() {
        HttpUrl pokemonUrl = HttpUrl.parse((String)"https://pokeapi.co/api/{pokemon_name}/pokemon/{pokemon_name}");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        filters.put("pokemon_name", (Object)"Misty");
        filters.put("param1", (Object)"value1");
        filters.put("repos", (Object)"drill");
        Assert.assertEquals((Object)"https://pokeapi.co/api/Misty/pokemon/Misty", (Object)SimpleHttp.mapURLParameters((HttpUrl)pokemonUrl, (Map)filters));
    }

    @Test
    public void testDefaultParametersWithDifferentDatatypes() {
        HttpUrl pokemonUrl = HttpUrl.parse((String)"https://pokeapi.co/api/{boolean=true}/{int=1234}");
        CaseInsensitiveMap filters = CaseInsensitiveMap.newHashMap();
        Assert.assertEquals((Object)"https://pokeapi.co/api/true/1234", (Object)SimpleHttp.mapURLParameters((HttpUrl)pokemonUrl, (Map)filters));
    }

    @Test
    public void testDefaultParameterExtractor() {
        HttpUrl pokemonUrl = HttpUrl.parse((String)"https://pokeapi.co/api/{pokemon_name=Misty}");
        String defaultValue = SimpleHttp.getDefaultParameterValue((HttpUrl)pokemonUrl, (String)"pokemon_name");
        Assert.assertEquals((Object)"Misty", (Object)defaultValue);
    }

    @Test
    public void testDefaultParameterExtractorWithBlankDefault() {
        HttpUrl pokemonUrl = HttpUrl.parse((String)"https://pokeapi.co/api/{pokemon_name=}");
        try {
            SimpleHttp.getDefaultParameterValue((HttpUrl)pokemonUrl, (String)"pokemon_name");
            Assert.fail();
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Default URL parameters must have a value."));
        }
    }
}

