/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.store.http.HttpApiConfig;
import org.apache.drill.exec.store.http.HttpPaginatorConfig;
import org.apache.drill.exec.store.http.HttpStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryRowSetIterator;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestPagination
extends ClusterTest {
    private static final int MOCK_SERVER_PORT = 8092;
    private static String TEST_CSV_RESPONSE;
    private static String TEST_CSV_RESPONSE_2;
    private static String TEST_CSV_RESPONSE_3;
    private static String TEST_CSV_RESPONSE_4;
    private static String TEST_JSON_PAGE1;
    private static String TEST_JSON_PAGE2;
    private static String TEST_JSON_PAGE3;
    private static String TEST_XML_PAGE1;
    private static String TEST_XML_PAGE2;
    private static String TEST_XML_PAGE3;

    @BeforeClass
    public static void setup() throws Exception {
        TestPagination.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TEST_CSV_RESPONSE = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response.csv"), (Charset)Charsets.UTF_8).read();
        TEST_CSV_RESPONSE_2 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response_2.csv"), (Charset)Charsets.UTF_8).read();
        TEST_CSV_RESPONSE_3 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response_3.csv"), (Charset)Charsets.UTF_8).read();
        TEST_CSV_RESPONSE_4 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response_4.csv"), (Charset)Charsets.UTF_8).read();
        TEST_JSON_PAGE1 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/p1.json"), (Charset)Charsets.UTF_8).read();
        TEST_JSON_PAGE2 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/p2.json"), (Charset)Charsets.UTF_8).read();
        TEST_JSON_PAGE3 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/p3.json"), (Charset)Charsets.UTF_8).read();
        TEST_XML_PAGE1 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response_1.xml"), (Charset)Charsets.UTF_8).read();
        TEST_XML_PAGE2 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response_2.xml"), (Charset)Charsets.UTF_8).read();
        TEST_XML_PAGE3 = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/data/response_3.xml"), (Charset)Charsets.UTF_8).read();
        dirTestWatcher.copyResourceToRoot(Paths.get("data/", new String[0]));
        TestPagination.makeMockConfig(cluster);
        TestPagination.makeLiveConfig(cluster);
    }

    public static void makeLiveConfig(ClusterFixture cluster) {
        HashMap<String, String> uaHeaders = new HashMap<String, String>();
        uaHeaders.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36");
        HttpPaginatorConfig githubPagePaginator = HttpPaginatorConfig.builder().pageParam("page").pageSizeParam("per_page").pageSize(5).method("PAGE").build();
        HttpApiConfig githubConfig = HttpApiConfig.builder().url("https://api.github.com/orgs/{org}/repos").method("get").requireTail(false).headers(uaHeaders).inputType("json").paginator(githubPagePaginator).build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("github", githubConfig);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(10), "", Integer.valueOf(80), "", "", "", null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("live", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    public static void makeMockConfig(ClusterFixture cluster) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header1", "value1");
        headers.put("header2", "value2");
        HttpPaginatorConfig offsetPaginatorForJson = HttpPaginatorConfig.builder().limitParam("limit").offsetParam("offset").method("offset").pageSize(2).build();
        HttpApiConfig mockJsonConfigWithPaginator = HttpApiConfig.builder().url("http://localhost:8092/json").method("get").headers(headers).requireTail(false).paginator(offsetPaginatorForJson).inputType("json").build();
        HttpPaginatorConfig pagePaginatorForXML = HttpPaginatorConfig.builder().method("page").pageParam("page").pageSizeParam("pageSize").pageSize(3).build();
        ArrayList<String> params = new ArrayList<String>();
        params.add("foo");
        HttpApiConfig mockXmlConfigWithPaginator = HttpApiConfig.builder().url("http://localhost:8092/xml").method("GET").requireTail(false).params(params).paginator(pagePaginatorForXML).inputType("xml").xmlDataLevel(2).build();
        HttpApiConfig mockXmlConfigWithPaginatorAndUrlParams = HttpApiConfig.builder().url("http://localhost:8092/xml/{org}").method("GET").requireTail(false).params(params).paginator(pagePaginatorForXML).inputType("xml").xmlDataLevel(2).build();
        HttpApiConfig mockCsvConfigWithPaginator = HttpApiConfig.builder().url("http://localhost:8092/csv").method("get").paginator(offsetPaginatorForJson).inputType("csv").requireTail(false).dataPath("results").build();
        HashMap<String, HttpApiConfig> configs = new HashMap<String, HttpApiConfig>();
        configs.put("csv_paginator", mockCsvConfigWithPaginator);
        configs.put("json_paginator", mockJsonConfigWithPaginator);
        configs.put("xml_paginator", mockXmlConfigWithPaginator);
        configs.put("xml_paginator_url_params", mockXmlConfigWithPaginatorAndUrlParams);
        HttpStoragePluginConfig mockStorageConfigWithWorkspace = new HttpStoragePluginConfig(Boolean.valueOf(false), configs, Integer.valueOf(2), "", Integer.valueOf(80), "", "", "", null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        mockStorageConfigWithWorkspace.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("local", (StoragePluginConfig)mockStorageConfigWithWorkspace);
    }

    @Test
    @Ignore(value="Requires Live Connection to Github")
    public void testPagePaginationWithURLParameters() throws Exception {
        String sql = "SELECT * FROM live.github WHERE org='apache' LIMIT 15";
        List results = client.queryBuilder().sql(sql).results();
        Assert.assertEquals((long)3L, (long)results.size());
        int count = 0;
        for (QueryDataBatch b : results) {
            count += b.getHeader().getRowCount();
            b.release();
        }
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)15L, (long)count);
    }

    @Test
    public void simpleJSONPaginatorQuery() throws Exception {
        String sql = "SELECT * FROM `local`.`json_paginator` LIMIT 4";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE3));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void simpleJSONPaginatorQueryWithoutLimit() throws Exception {
        String sql = "SELECT * FROM `local`.`json_paginator`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE3));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((long)5L, (long)count);
        }
    }

    @Test
    public void simpleJSONPaginatorQueryWithoutLimitAndEvenResults() throws Exception {
        String sql = "SELECT * FROM `local`.`json_paginator`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_JSON_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(404).setBody(""));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void simpleCSVPaginatorQuery() throws Exception {
        String sql = "SELECT * FROM `local`.`csv_paginator` LIMIT 6";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_3));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)6L, (long)count);
        }
    }

    @Test
    public void simpleCSVPaginatorQueryWithoutLimit() throws Exception {
        String sql = "SELECT * FROM `local`.`csv_paginator`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_3));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_4));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)7L, (long)count);
        }
    }

    @Test
    public void simpleCSVPaginatorQueryWithoutLimitAndEvenResults() throws Exception {
        String sql = "SELECT * FROM `local`.`csv_paginator`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_CSV_RESPONSE_3));
            server.enqueue(new MockResponse().setResponseCode(404).setBody(""));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)6L, (long)count);
        }
    }

    @Test
    public void simpleXMLPaginatorQuery() throws Exception {
        String sql = "SELECT * FROM `local`.`xml_paginator` LIMIT 6";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE3));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)6L, (long)count);
        }
    }

    @Test
    public void simpleXMLPaginatorQueryWithoutLimit() throws Exception {
        String sql = "SELECT * FROM `local`.`xml_paginator`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE3));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((long)8L, (long)count);
        }
    }

    @Test
    public void testAggregateQuery() throws Exception {
        String sql = "SELECT ZONE, COUNT(*) AS row_count FROM `local`.`xml_paginator` GROUP BY ZONE";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE3));
            QueryRowSetIterator iterator = client.queryBuilder().sql(sql).rowSetIterator();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ZONE", TypeProtos.MinorType.VARCHAR).add("row_count", TypeProtos.MinorType.BIGINT).build();
            RowSet.SingleRowSet expectedFirstRow = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"4", 5}).build();
            RowSet.SingleRowSet expectedSecondRow = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"3", 3}).build();
            int count = 0;
            while (iterator.hasNext()) {
                DirectRowSet results = iterator.next();
                if (results.rowCount() <= 0) continue;
                if (count == 0) {
                    RowSetUtilities.verify((RowSet)expectedFirstRow, (RowSet)results);
                } else if (count == 1) {
                    RowSetUtilities.verify((RowSet)expectedSecondRow, (RowSet)results);
                }
                ++count;
            }
        }
    }

    @Test
    public void simpleXMLPaginatorQueryWithoutLimitAndEvenResults() throws Exception {
        String sql = "SELECT * FROM `local`.`xml_paginator`";
        try (MockWebServer server = this.startServer();){
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE1));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(TEST_XML_PAGE2));
            server.enqueue(new MockResponse().setResponseCode(200).setBody(""));
            List results = client.queryBuilder().sql(sql).results();
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)6L, (long)count);
        }
    }

    public MockWebServer startServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.start(8092);
        return server;
    }
}

