/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.PlanTestBase;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.hbase.BaseHBaseTest;
import org.apache.drill.hbase.HBaseTestsSuite;
import org.apache.drill.hbase.TestTableGenerator;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestHBaseQueries
extends BaseHBaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithEmptyFirstAndLastRegion() throws Exception {
        HBaseAdmin admin = (HBaseAdmin)HBaseTestsSuite.getAdmin();
        TableName tableName = TableName.valueOf((String)"drill_ut_empty_regions");
        try (Table table = HBaseTestsSuite.getConnection().getTable(tableName);){
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor("f"));
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(TestTableGenerator.SPLIT_KEYS, 0, 2));
            Put p = new Put("b".getBytes(StandardCharsets.UTF_8));
            p.addColumn("f".getBytes(StandardCharsets.UTF_8), "c".getBytes(StandardCharsets.UTF_8), "1".getBytes(StandardCharsets.UTF_8));
            table.put(p);
            this.setColumnWidths(new int[]{8, 15});
            this.runHBaseSQLVerifyCount("SELECT *\nFROM\n  hbase.`" + tableName + "` tableName\n", 1);
        }
        finally {
            try {
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithEmptyTable() throws Exception {
        Admin admin = HBaseTestsSuite.getAdmin();
        TableName tableName = TableName.valueOf((String)"drill_ut_empty_table");
        try (Table table = HBaseTestsSuite.getConnection().getTable(tableName);){
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor("f"));
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(TestTableGenerator.SPLIT_KEYS, 0, 2));
            this.setColumnWidths(new int[]{8, 15});
            this.runHBaseSQLVerifyCount("SELECT row_key, count(*)\nFROM\n  hbase.`" + tableName + "` tableName GROUP BY row_key\n", 0);
        }
        finally {
            try {
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testCastEmptyStrings() throws Exception {
        try {
            TestHBaseQueries.test((String)"alter system set `drill.exec.functions.cast_empty_string_to_null` = true;");
            this.setColumnWidths(new int[]{5, 4});
            List<QueryDataBatch> resultList = this.runHBaseSQLlWithResults("SELECT row_key,\n CAST(t.f.c1 as INT) c1, CAST(t.f.c2 as BIGINT) c2, CAST(t.f.c3 as INT) c3,\n CAST(t.f.c4 as INT) c4 FROM hbase.TestTableNullStr t where row_key='a1'");
            this.logResult(resultList);
        }
        finally {
            TestHBaseQueries.test((String)"alter system reset `drill.exec.functions.cast_empty_string_to_null`;");
        }
    }

    @Test
    public void testSelectFromSchema() throws Exception {
        this.setColumnWidths(new int[]{8, 15});
        TestHBaseQueries.test((String)"USE hbase");
        this.runHBaseSQLVerifyCount("SELECT row_key\n FROM hbase.TestTableNullStr t WHERE row_key='a1'", 1);
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        PlanTestBase.testPhysicalPlanExecutionBasedOnQuery((String)"select * from hbase.TestTableNullStr");
    }
}

