/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import org.apache.drill.PlanTestBase;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.hbase.BaseHBaseTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestHBaseFilterPushDown
extends BaseHBaseTest {
    @Test
    public void testFilterPushDownRowKeyEqual() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4'", 1);
        String[] expectedPlan = new String[]{".*startRow=\"b4\", stopRow=\"b4\\\\x00\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyNotEqual() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key <> 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key <> 'b4'", 7);
        String[] expectedPlan = new String[]{".*startRow=\"\", stopRow=\"\", filter=\"RowFilter \\(NOT_EQUAL, b4\\)\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key <> 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyEqualWithItem() throws Exception {
        this.setColumnWidths(new int[]{20, 30});
        String sql = "SELECT\n  cast(tableName.row_key as varchar(20)), cast(tableName.f.c1 as varchar(30))\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  cast(tableName.row_key as varchar(20)), cast(tableName.f.c1 as varchar(30))\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4'", 1);
        String[] expectedPlan = new String[]{".*startRow=\"b4\", stopRow=\"b4\\\\x00\".*"};
        String[] excludedPlan = new String[]{".*startRow=null, stopRow=null.*"};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  cast(tableName.row_key as varchar(20)), cast(tableName.f.c1 as varchar(30))\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownCompositeDateRowKey1() throws Exception {
        this.setColumnWidths(new int[]{11, 22, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeDate` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') < DATE '2015-06-18' AND\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') > DATE '2015-06-13'", 12);
    }

    @Test
    public void testFilterPushDownCompositeDateRowKey2() throws Exception {
        this.setColumnWidths(new int[]{11, 22, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeDate` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') = DATE '2015-08-22'", 3);
    }

    @Test
    public void testFilterPushDownCompositeDateRowKey3() throws Exception {
        this.setColumnWidths(new int[]{11, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeDate` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') < DATE '2015-06-18' AND\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') > DATE '2015-06-13'", 1);
    }

    @Test
    public void testFilterPushDownCompositeDateRowKey4() throws Exception {
        this.setColumnWidths(new int[]{30, 22, 30, 10});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'timestamp_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') t\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeDate` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'timestamp_epoch_be') >= TIMESTAMP '2015-06-18 08:00:00.000' AND\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'timestamp_epoch_be') < TIMESTAMP '2015-06-20 16:00:00.000'", 7);
    }

    @Test
    public void testFilterPushDownCompositeTimeRowKey1() throws Exception {
        this.setColumnWidths(new int[]{50, 40, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeTime` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') = TIME '23:57:15.275'", 1);
    }

    @Test
    public void testFilterPushDownCompositeTimeRowKey2() throws Exception {
        this.setColumnWidths(new int[]{30, 2002, 32});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeTime` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') = TIME '23:55:51.250'", 1);
    }

    @Test
    public void testFilterPushDownCompositeTimeRowKey3() throws Exception {
        this.setColumnWidths(new int[]{30, 22, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeTime` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') > TIME '23:57:06' AND CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') < TIME '23:59:59'", 8);
    }

    @Test
    public void testFilterPushDownCompositeBigIntRowKey1() throws Exception {
        this.setColumnWidths(new int[]{15, 40, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'bigint_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeDate` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'bigint_be') = cast(1409040000000 as bigint)", 1);
    }

    @Test
    public void testFilterPushDownCompositeBigIntRowKey2() throws Exception {
        this.setColumnWidths(new int[]{16, 22, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'bigint_be') i\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'date_epoch_be') d\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'time_epoch_be') t\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 9, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeDate` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'uint8_be') > cast(1438300800000 as bigint) AND\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 8), 'uint8_be') < cast(1438617600000 as bigint)", 10);
    }

    @Test
    public void testFilterPushDownCompositeIntRowKey1() throws Exception {
        this.setColumnWidths(new int[]{16, 22, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') i\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 5, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeInt` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') >= cast(423 as int) AND CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') < cast(940 as int)", 11);
    }

    @Test
    public void testFilterPushDownCompositeIntRowKey2() throws Exception {
        this.setColumnWidths(new int[]{16, 2002, 32});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') i\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 5, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeInt` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') >= cast(300 as int) AND CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') < cast(900 as int)", 1);
    }

    @Test
    public void testFilterPushDownCompositeIntRowKey3() throws Exception {
        this.setColumnWidths(new int[]{16, 22, 32});
        this.runHBaseSQLVerifyCount("SELECT \n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') i\n, CONVERT_FROM(BYTE_SUBSTR(row_key, 5, 8), 'bigint_be') id\n, CONVERT_FROM(tableName.f.c, 'UTF8') \n FROM hbase.`TestTableCompositeInt` tableName\n WHERE\n CONVERT_FROM(BYTE_SUBSTR(row_key, 1, 4), 'uint4_be') = cast(658 as int)", 1);
    }

    @Test
    public void testFilterPushDownDoubleOB() throws Exception {
        this.setColumnWidths(new int[]{8, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'DOUBLE_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableDoubleOB` t\nWHERE\n  CONVERT_FROM(row_key, 'DOUBLE_OB') > cast(95.54 as DOUBLE)", 6);
    }

    @Test
    public void testFilterPushDownDoubleOBPlan() throws Exception {
        this.setColumnWidths(new int[]{8, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'DOUBLE_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableDoubleOB` t\nWHERE\n  CONVERT_FROM(row_key, 'DOUBLE_OB') > cast(95.54 as DOUBLE)", 1);
    }

    @Test
    public void testFilterPushDownDoubleOBDesc() throws Exception {
        this.setColumnWidths(new int[]{8, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'DOUBLE_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableDoubleOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'DOUBLE_OBD') > cast(95.54 as DOUBLE)", 6);
    }

    @Test
    public void testFilterPushDownDoubleOBDescPlan() throws Exception {
        this.setColumnWidths(new int[]{8, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'DOUBLE_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableDoubleOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'DOUBLE_OBD') > cast(95.54 as DOUBLE)", 1);
    }

    @Test
    public void testFilterPushDownIntOB() throws Exception {
        this.setColumnWidths(new int[]{15, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'INT_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableIntOB` t\nWHERE\n  CONVERT_FROM(row_key, 'INT_OB') >= cast(-32 as INT) AND  CONVERT_FROM(row_key, 'INT_OB') < cast(59 as INT)", 91);
    }

    @Test
    public void testFilterPushDownIntOBDesc() throws Exception {
        this.setColumnWidths(new int[]{15, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'INT_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableIntOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'INT_OBD') >= cast(-32 as INT) AND  CONVERT_FROM(row_key, 'INT_OBD') < cast(59 as INT)", 91);
    }

    @Test
    public void testFilterPushDownIntOBPlan() throws Exception {
        this.setColumnWidths(new int[]{15, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'INT_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableIntOB` t\nWHERE\n  CONVERT_FROM(row_key, 'INT_OB') > cast(-23 as INT) AND  CONVERT_FROM(row_key, 'INT_OB') < cast(14 as INT)", 1);
    }

    @Test
    public void testFilterPushDownIntOBDescPlan() throws Exception {
        this.setColumnWidths(new int[]{15, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'INT_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableIntOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'INT_OBD') > cast(-23 as INT) AND  CONVERT_FROM(row_key, 'INT_OBD') < cast(14 as INT)", 1);
    }

    @Test
    public void testFilterPushDownBigIntOB() throws Exception {
        this.setColumnWidths(new int[]{15, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'BIGINT_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableBigIntOB` t\nWHERE\n  CONVERT_FROM(row_key, 'BIGINT_OB') > cast(1438034423063 as BIGINT) AND  CONVERT_FROM(row_key, 'BIGINT_OB') <= cast(1438034423097 as BIGINT)", 34);
    }

    @Test
    public void testFilterPushDownBigIntOBPlan() throws Exception {
        this.setColumnWidths(new int[]{15, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'BIGINT_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableBigIntOB` t\nWHERE\n  CONVERT_FROM(row_key, 'BIGINT_OB') > cast(1438034423063 as BIGINT) AND  CONVERT_FROM(row_key, 'BIGINT_OB') < cast(1438034423097 as BIGINT)", 1);
    }

    @Test
    public void testFilterPushDownFloatOB() throws Exception {
        this.setColumnWidths(new int[]{8, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'FLOAT_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableFloatOB` t\nWHERE\n  CONVERT_FROM(row_key, 'FLOAT_OB') > cast(95.74 as FLOAT) AND  CONVERT_FROM(row_key, 'FLOAT_OB') < cast(99.5 as FLOAT)", 5);
    }

    @Test
    public void testFilterPushDownFloatOBPlan() throws Exception {
        this.setColumnWidths(new int[]{8, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'FLOAT_OB') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableFloatOB` t\nWHERE\n  CONVERT_FROM(row_key, 'FLOAT_OB') > cast(95.54 as FLOAT) AND  CONVERT_FROM(row_key, 'FLOAT_OB') < cast(99.77 as FLOAT)", 1);
    }

    @Test
    public void testFilterPushDownBigIntOBDesc() throws Exception {
        this.setColumnWidths(new int[]{15, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'BIGINT_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableBigIntOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'BIGINT_OBD') > cast(1438034423063 as BIGINT) AND  CONVERT_FROM(row_key, 'BIGINT_OBD') <= cast(1438034423097 as BIGINT)", 34);
    }

    @Test
    public void testFilterPushDownBigIntOBDescPlan() throws Exception {
        this.setColumnWidths(new int[]{15, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'BIGINT_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableBigIntOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'BIGINT_OBD') > cast(1438034423063 as BIGINT) AND  CONVERT_FROM(row_key, 'BIGINT_OBD') < cast(1438034423097 as BIGINT)", 1);
    }

    @Test
    public void testFilterPushDownFloatOBDesc() throws Exception {
        this.setColumnWidths(new int[]{8, 25});
        this.runHBaseSQLVerifyCount("SELECT\n convert_from(t.row_key, 'FLOAT_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableFloatOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'FLOAT_OBD') > cast(95.74 as FLOAT) AND  CONVERT_FROM(row_key, 'FLOAT_OBD') < cast(99.5 as FLOAT)", 5);
    }

    @Test
    public void testFilterPushDownFloatOBDescPlan() throws Exception {
        this.setColumnWidths(new int[]{8, 2000});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n convert_from(t.row_key, 'FLOAT_OBD') rk,\n convert_from(t.`f`.`c`, 'UTF8') val\nFROM\n  hbase.`TestTableFloatOBDesc` t\nWHERE\n  CONVERT_FROM(row_key, 'FLOAT_OBD') > cast(95.54 as FLOAT) AND  CONVERT_FROM(row_key, 'FLOAT_OBD') < cast(99.77 as FLOAT)", 1);
    }

    @Test
    public void testFilterPushDownRowKeyLike() throws Exception {
        this.setColumnWidths(new int[]{8, 22});
        String sql = "SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n  row_key LIKE '08%0' OR row_key LIKE '%70'";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n  row_key LIKE '08%0' OR row_key LIKE '%70'", 21);
        String[] expectedPlan = new String[]{".*filter=\"FilterList OR.*EQUAL.*EQUAL.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n  row_key LIKE '08%0' OR row_key LIKE '%70'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyLikeWithEscape() throws Exception {
        this.setColumnWidths(new int[]{8, 22});
        String sql = "SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n  row_key LIKE '!%!_AS!_PREFIX!_%' ESCAPE '!'";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n  row_key LIKE '!%!_AS!_PREFIX!_%' ESCAPE '!'", 2);
        String[] expectedPlan = new String[]{".*startRow=\"\\%_AS_PREFIX_\", stopRow=\"\\%_AS_PREFIX`\", filter=\"RowFilter.*EQUAL.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n  row_key LIKE '!%!_AS!_PREFIX!_%' ESCAPE '!'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyRangeAndColumnValueLike() throws Exception {
        this.setColumnWidths(new int[]{8, 22});
        String sql = "SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n row_key >= '07' AND row_key < '09' AND tableName.f.c LIKE 'value 0%9'";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n row_key >= '07' AND row_key < '09' AND tableName.f.c LIKE 'value 0%9'", 22);
        String[] expectedPlan = new String[]{".*startRow=\"07\", stopRow=\"09\", filter=\"FilterList AND.*RowFilter \\(GREATER_OR_EQUAL, 07\\), RowFilter \\(LESS, 09\\), SingleColumnValueFilter \\(f, c, EQUAL.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, convert_from(tableName.f.c, 'UTF8') `f.c`\nFROM\n  hbase.`TestTable3` tableName\nWHERE\n row_key >= '07' AND row_key < '09' AND tableName.f.c LIKE 'value 0%9'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyGreaterThan() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key > 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key > 'b4'", 4);
        String[] expectedPlan = new String[]{".*startRow=\"b4\\\\x00\", stopRow=\"\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key > 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyGreaterThanWithItem() throws Exception {
        this.setColumnWidths(new int[]{8, 38});
        String sql = "SELECT\n  row_key, tableName.f2.c3\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key > 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, tableName.f2.c3\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key > 'b4'", 2);
        String[] expectedPlan = new String[]{".*startRow=\"b4\\\\x00\".*stopRow=.*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, tableName.f2.c3\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key > 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyBetween() throws Exception {
        this.setColumnWidths(new int[]{8, 74, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key BETWEEN 'a2' AND 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key BETWEEN 'a2' AND 'b4'", 3);
        String[] expectedPlan = new String[]{".*startRow=\"a2\", stopRow=\"b4\\\\x00\", filter=\"FilterList AND.*GREATER_OR_EQUAL, a2.*LESS_OR_EQUAL, b4.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key BETWEEN 'a2' AND 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyBetweenWithItem() throws Exception {
        this.setColumnWidths(new int[]{8, 12});
        String sql = "SELECT\n  row_key, tableName.f.c1\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key BETWEEN 'a2' AND 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, tableName.f.c1\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key BETWEEN 'a2' AND 'b4'", 3);
        String[] expectedPlan = new String[]{".*startRow=\"a2\", stopRow=\"b4\\\\x00\", filter=\"FilterList AND.*GREATER_OR_EQUAL, a2.*LESS_OR_EQUAL, b4.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, tableName.f.c1\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key BETWEEN 'a2' AND 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownMultiColumns() throws Exception {
        this.setColumnWidths(new int[]{8, 74, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  (row_key >= 'b5' OR row_key <= 'a2') AND (t.f.c1 >= '1' OR t.f.c1 is null)";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  (row_key >= 'b5' OR row_key <= 'a2') AND (t.f.c1 >= '1' OR t.f.c1 is null)", 5);
        String[] expectedPlan = new String[]{".*startRow=\"\", stopRow=\"\", filter=\"FilterList OR.*LESS_OR_EQUAL, a2.*GREATER_OR_EQUAL, b5.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  (row_key >= 'b5' OR row_key <= 'a2') AND (t.f.c1 >= '1' OR t.f.c1 is null)");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownMultiColumnsWithItem() throws Exception {
        this.setColumnWidths(new int[]{8, 8});
        String sql = "SELECT\n  row_key, t.f.c1\nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  (row_key >= 'b5' OR row_key <= 'a2') AND (t.f.c1 >= '1' OR t.f.c1 is null)";
        String[] expectedPlan = new String[]{".*startRow=\"\", stopRow=\"\", filter=\"FilterList OR.*LESS_OR_EQUAL, a2.*GREATER_OR_EQUAL, b5.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, t.f.c1\nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  (row_key >= 'b5' OR row_key <= 'a2') AND (t.f.c1 >= '1' OR t.f.c1 is null)");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownConvertExpression() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'UTF8') > 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'UTF8') > 'b4'", 4);
        String[] expectedPlan = new String[]{".*startRow=\"b4\\\\x00\", stopRow=\"\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'UTF8') > 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownConvertExpressionWithItem() throws Exception {
        this.setColumnWidths(new int[]{8, 38});
        String sql = "SELECT\n  row_key, tableName.f2.c3\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'UTF8') > 'b4'";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, tableName.f2.c3\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'UTF8') > 'b4'", 2);
        String[] expectedPlan = new String[]{".*startRow=\"b4\\\\x00\", stopRow=\"\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, tableName.f2.c3\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'UTF8') > 'b4'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownConvertExpressionWithNumber() throws Exception {
        this.setColumnWidths(new int[]{8, 1100});
        this.runHBaseSQLVerifyCount("EXPLAIN PLAN FOR\nSELECT\n  row_key\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  convert_from(row_key, 'INT_BE') = 75", 1);
    }

    @Test
    public void testFilterPushDownRowKeyLessThanOrEqualTo() throws Exception {
        this.setColumnWidths(new int[]{8, 74, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  'b4' >= row_key";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  'b4' >= row_key", 4);
        String[] expectedPlan = new String[]{".*startRow=\"\", stopRow=\"b4\\\\x00\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  'b4' >= row_key");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownRowKeyLessThanOrEqualToWithItem() throws Exception {
        this.setColumnWidths(new int[]{8, 12});
        String sql = "SELECT\n  row_key, tableName.f.c1\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  'b4' >= row_key";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, tableName.f.c1\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  'b4' >= row_key", 4);
        String[] expectedPlan = new String[]{".*startRow=\"\", stopRow=\"b4\\\\x00\".*"};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  row_key, tableName.f.c1\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  'b4' >= row_key");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownOrRowKeyEqual() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4' or row_key = 'a2'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4' or row_key = 'a2'", 2);
        String[] expectedPlan = new String[]{".*startRow=\"a2\", stopRow=\"b4\\\\x00\", filter=\"FilterList OR \\(2/2\\): \\[RowFilter \\(EQUAL, a2\\), RowFilter \\(EQUAL, b4\\).*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'b4' or row_key = 'a2'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownOrRowKeyInPred() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key in ('b4', 'a2')";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key in ('b4', 'a2')", 2);
        String[] expectedPlan = new String[]{".*startRow=\"a2\", stopRow=\"b4\\\\x00\", filter=\"FilterList OR \\(2/2\\): \\[RowFilter \\(EQUAL, a2\\), RowFilter \\(EQUAL, b4\\).*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key in ('b4', 'a2')");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testFilterPushDownOrRowKeyEqualRangePred() throws Exception {
        this.setColumnWidths(new int[]{8, 38, 38});
        String sql = "SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'a2' or row_key between 'b5' and 'b6'";
        this.runHBaseSQLVerifyCount("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'a2' or row_key between 'b5' and 'b6'", 3);
        String[] expectedPlan = new String[]{".*startRow=\"a2\", stopRow=\"b6\\\\x00\", filter=\"FilterList OR \\(2/2\\): \\[RowFilter \\(EQUAL, a2\\), FilterList AND \\(2/2\\): \\[RowFilter \\(GREATER_OR_EQUAL, b5\\), RowFilter \\(LESS_OR_EQUAL, b6.*\""};
        String[] excludedPlan = new String[]{};
        String sqlHBase = this.canonizeHBaseSQL("SELECT\n  *\nFROM\n  hbase.`[TABLE_NAME]` tableName\nWHERE\n  row_key = 'a2' or row_key between 'b5' and 'b6'");
        PlanTestBase.testPlanMatchingPatterns((String)sqlHBase, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testDummyColumnsAreAvoided() throws Exception {
        this.setColumnWidth(10);
        String sql = "SELECT\n  row_key, \n  t.f .c2, t.f .c3, \n  t.f2.c2, t.f2.c3 \nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  row_key = 'a3' OR row_key = 'b7' \nORDER BY row_key";
        this.runHBaseSQLVerifyCount("SELECT\n  row_key, \n  t.f .c2, t.f .c3, \n  t.f2.c2, t.f2.c3 \nFROM\n  hbase.`[TABLE_NAME]` t\nWHERE\n  row_key = 'a3' OR row_key = 'b7' \nORDER BY row_key", 2);
    }

    @Test
    public void testConvertFromPushDownWithView() throws Exception {
        TestHBaseFilterPushDown.test((String)"create view dfs.tmp.pd_view as\nselect convert_from(byte_substr(row_key, 1, 8), 'date_epoch_be') as d\nfrom hbase.`TestTableCompositeDate`");
        String query = "select d from dfs.tmp.pd_view where d > date '2015-06-13' and d < DATE '2015-06-18'";
        String[] expectedPlan = new String[]{"startRow=\"\\\\x00\\\\x00\\\\x01M\\\\xEF\\]\\\\xA0\\\\x00\", stopRow=\"\\\\x00\\\\x00\\\\x01N\\\\x03\\\\xF7\\\\x10\\\\x00\""};
        String[] excludedPlan = new String[]{"Filter\\("};
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])expectedPlan, (String[])excludedPlan);
        this.runHBaseSQLVerifyCount(query, 12);
    }
}

