/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.nio.charset.StandardCharsets;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.hbase.BaseHBaseTest;
import org.apache.drill.hbase.HBaseTestsSuite;
import org.apache.drill.test.TestBuilder;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class HBaseRecordReaderTest
extends BaseHBaseTest {
    @Test
    public void testLocalDistributed() throws Exception {
        String planName = "/hbase/hbase_scan_screen_physical.json";
        this.runHBasePhysicalVerifyCount(planName, HBaseTestsSuite.TEST_TABLE_1.getNameAsString(), 8);
    }

    @Test
    public void testLocalDistributedColumnSelect() throws Exception {
        String planName = "/hbase/hbase_scan_screen_physical_column_select.json";
        this.runHBasePhysicalVerifyCount(planName, HBaseTestsSuite.TEST_TABLE_1.getNameAsString(), 3);
    }

    @Test
    public void testLocalDistributedFamilySelect() throws Exception {
        String planName = "/hbase/hbase_scan_screen_physical_family_select.json";
        this.runHBasePhysicalVerifyCount(planName, HBaseTestsSuite.TEST_TABLE_1.getNameAsString(), 4);
    }

    @Test
    public void testOrderBy() throws Exception {
        HBaseRecordReaderTest.testBuilder().sqlQuery("select cast(row_key AS VARCHAR) as row_key, t.f from hbase.`TestTable2` t order by t.f.c1").ordered().baselineColumns(new String[]{"row_key", "f"}).baselineValues(new Object[]{"a2", TestBuilder.mapOf((Object[])new Object[]{"c1", "11".getBytes(StandardCharsets.UTF_8), "c2", "12".getBytes(StandardCharsets.UTF_8), "c3", "13".getBytes(StandardCharsets.UTF_8)})}).baselineValues(new Object[]{"a1", TestBuilder.mapOf((Object[])new Object[]{"c1", "21".getBytes(StandardCharsets.UTF_8), "c2", "22".getBytes(StandardCharsets.UTF_8), "c3", "23".getBytes(StandardCharsets.UTF_8)})}).baselineValues(new Object[]{"a3", TestBuilder.mapOf((Object[])new Object[]{"c1", "31".getBytes(StandardCharsets.UTF_8), "c2", "32".getBytes(StandardCharsets.UTF_8), "c3", "33".getBytes(StandardCharsets.UTF_8)})}).go();
    }

    @Test
    public void testMultiCFDifferentCase() throws Exception {
        HBaseRecordReaderTest.testBuilder().sqlQuery("select * from hbase.`TestTableMultiCF` t").unOrdered().baselineColumns(new String[]{"row_key", "F", "f0"}).baselineValues(new Object[]{"a1".getBytes(StandardCharsets.UTF_8), TestBuilder.mapOf((Object[])new Object[]{"c3", "23".getBytes(StandardCharsets.UTF_8)}), TestBuilder.mapOf((Object[])new Object[]{"c1", "21".getBytes(StandardCharsets.UTF_8), "c2", "22".getBytes(StandardCharsets.UTF_8)})}).baselineValues(new Object[]{"a2".getBytes(StandardCharsets.UTF_8), TestBuilder.mapOf((Object[])new Object[]{"c3", "13".getBytes(StandardCharsets.UTF_8)}), TestBuilder.mapOf((Object[])new Object[]{"c1", "11".getBytes(StandardCharsets.UTF_8), "c2", "12".getBytes(StandardCharsets.UTF_8)})}).baselineValues(new Object[]{"a3".getBytes(StandardCharsets.UTF_8), TestBuilder.mapOf((Object[])new Object[]{"c3", "33".getBytes(StandardCharsets.UTF_8)}), TestBuilder.mapOf((Object[])new Object[]{"c1", "31".getBytes(StandardCharsets.UTF_8), "c2", "32".getBytes(StandardCharsets.UTF_8)})}).go();
    }
}

