/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;

public class TestTableGenerator {
    public static final byte[][] SPLIT_KEYS = new byte[][]{{98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}};
    static final byte[] FAMILY_F = new byte[]{102};
    static final byte[] COLUMN_C = new byte[]{99};

    public static void generateHBaseDataset1(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        desc.addFamily(new HColumnDescriptor("f2"));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        Put p = new Put("a1".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "2".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "3".getBytes());
        p.addColumn("f".getBytes(), "c4".getBytes(), "4".getBytes());
        p.addColumn("f".getBytes(), "c5".getBytes(), "5".getBytes());
        p.addColumn("f".getBytes(), "c6".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put("a2".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "2".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "3".getBytes());
        p.addColumn("f".getBytes(), "c4".getBytes(), "4".getBytes());
        p.addColumn("f".getBytes(), "c5".getBytes(), "5".getBytes());
        p.addColumn("f".getBytes(), "c6".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put("a3".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "2".getBytes());
        p.addColumn("f".getBytes(), "c5".getBytes(), "3".getBytes());
        p.addColumn("f".getBytes(), "c7".getBytes(), "4".getBytes());
        p.addColumn("f".getBytes(), "c8".getBytes(), "5".getBytes());
        p.addColumn("f".getBytes(), "c9".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put(new byte[]{98, 52, 0});
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f2".getBytes(), "c2".getBytes(), "2".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "3".getBytes());
        p.addColumn("f2".getBytes(), "c4".getBytes(), "4".getBytes());
        p.addColumn("f".getBytes(), "c5".getBytes(), "5".getBytes());
        p.addColumn("f2".getBytes(), "c6".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put("b4".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f2".getBytes(), "c2".getBytes(), "2".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "3".getBytes());
        p.addColumn("f2".getBytes(), "c4".getBytes(), "4".getBytes());
        p.addColumn("f".getBytes(), "c5".getBytes(), "5".getBytes());
        p.addColumn("f2".getBytes(), "c6".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put("b5".getBytes());
        p.addColumn("f2".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "2".getBytes());
        p.addColumn("f2".getBytes(), "c3".getBytes(), "3".getBytes());
        p.addColumn("f".getBytes(), "c4".getBytes(), "4".getBytes());
        p.addColumn("f2".getBytes(), "c5".getBytes(), "5".getBytes());
        p.addColumn("f".getBytes(), "c6".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put("b6".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f2".getBytes(), "c3".getBytes(), "2".getBytes());
        p.addColumn("f".getBytes(), "c5".getBytes(), "3".getBytes());
        p.addColumn("f2".getBytes(), "c7".getBytes(), "4".getBytes());
        p.addColumn("f".getBytes(), "c8".getBytes(), "5".getBytes());
        p.addColumn("f2".getBytes(), "c9".getBytes(), "6".getBytes());
        table.mutate((Mutation)p);
        p = new Put("b7".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "1".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "2".getBytes());
        table.mutate((Mutation)p);
        table.close();
    }

    public static void generateHBaseDatasetSingleSchema(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        Put p = new Put("a1".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "21".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "22".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "23".getBytes());
        table.mutate((Mutation)p);
        p = new Put("a2".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "11".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "12".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "13".getBytes());
        table.mutate((Mutation)p);
        p = new Put("a3".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "31".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "32".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "33".getBytes());
        table.mutate((Mutation)p);
        table.close();
    }

    public static void generateHBaseDatasetMultiCF(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f0"));
        desc.addFamily(new HColumnDescriptor("F"));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        Put p = new Put("a1".getBytes());
        p.addColumn("f0".getBytes(), "c1".getBytes(), "21".getBytes());
        p.addColumn("f0".getBytes(), "c2".getBytes(), "22".getBytes());
        p.addColumn("F".getBytes(), "c3".getBytes(), "23".getBytes());
        table.mutate((Mutation)p);
        p = new Put("a2".getBytes());
        p.addColumn("f0".getBytes(), "c1".getBytes(), "11".getBytes());
        p.addColumn("f0".getBytes(), "c2".getBytes(), "12".getBytes());
        p.addColumn("F".getBytes(), "c3".getBytes(), "13".getBytes());
        table.mutate((Mutation)p);
        p = new Put("a3".getBytes());
        p.addColumn("f0".getBytes(), "c1".getBytes(), "31".getBytes());
        p.addColumn("f0".getBytes(), "c2".getBytes(), "32".getBytes());
        p.addColumn("F".getBytes(), "c3".getBytes(), "33".getBytes());
        table.mutate((Mutation)p);
        table.close();
    }

    public static void generateHBaseDataset2(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        int rowCount = 0;
        byte[] bytes = null;
        int numColumns = 5;
        Random random = new Random();
        int iteration = 0;
        while (rowCount < 1000) {
            char rowKeyChar = 'a';
            for (int i = 0; i < numberRegions; ++i) {
                Put p = new Put(("" + rowKeyChar + iteration).getBytes());
                for (int j = 1; j <= 5; ++j) {
                    bytes = new byte[5000];
                    random.nextBytes(bytes);
                    p.addColumn("f".getBytes(), ("c" + j).getBytes(), bytes);
                }
                table.mutate((Mutation)p);
                rowKeyChar = (char)(rowKeyChar + '\u0001');
                ++rowCount;
            }
            ++iteration;
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDataset3(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        Put p;
        int i;
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (i = 0; i <= 100; ++i) {
            p = new Put(String.format("%03d", i).getBytes());
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %03d", i).getBytes());
            table.mutate((Mutation)p);
        }
        for (i = 0; i <= 1000; ++i) {
            p = new Put(String.format("%04d", i).getBytes());
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %04d", i).getBytes());
            table.mutate((Mutation)p);
        }
        Put p2 = new Put("%_AS_PREFIX_ROW1".getBytes());
        p2.addColumn(FAMILY_F, COLUMN_C, "dummy".getBytes());
        table.mutate((Mutation)p2);
        p2 = new Put("%_AS_PREFIX_ROW2".getBytes());
        p2.addColumn(FAMILY_F, COLUMN_C, "dummy".getBytes());
        table.mutate((Mutation)p2);
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetCompositeKeyDate(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        Date startDate = new Date(1408924800000L);
        long startTime = startDate.getTime();
        long MILLISECONDS_IN_A_DAY = 86400000L;
        long MILLISECONDS_IN_A_YEAR = MILLISECONDS_IN_A_DAY * 365L;
        long endTime = startTime + MILLISECONDS_IN_A_YEAR;
        long interval = MILLISECONDS_IN_A_DAY / 3L;
        long ts = startTime;
        long counter = 0L;
        while (ts < endTime) {
            byte[] rowKey = ByteBuffer.allocate(16).putLong(ts).array();
            for (int i = 0; i < 8; ++i) {
                rowKey[8 + i] = (byte)(counter >> 56 - i * 8);
            }
            Put p = new Put(rowKey);
            p.addColumn(FAMILY_F, COLUMN_C, "dummy".getBytes());
            table.mutate((Mutation)p);
            ts += interval;
            ++counter;
        }
        table.close();
    }

    public static void generateHBaseDatasetCompositeKeyTime(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        long startTime = 0L;
        long MILLISECONDS_IN_A_SEC = 1000L;
        long MILLISECONDS_IN_A_DAY = MILLISECONDS_IN_A_SEC * 60L * 60L * 24L;
        long endTime = startTime + MILLISECONDS_IN_A_DAY;
        long smallInterval = 25L;
        long largeInterval = MILLISECONDS_IN_A_SEC * 42L;
        long interval = smallInterval;
        long ts = startTime;
        long counter = 0L;
        while (ts < endTime) {
            byte[] rowKey = ByteBuffer.allocate(16).putLong(ts).array();
            for (int i = 0; i < 8; ++i) {
                rowKey[8 + i] = (byte)(counter >> 56 - i * 8);
            }
            Put p = new Put(rowKey);
            p.addColumn(FAMILY_F, COLUMN_C, "dummy".getBytes());
            table.mutate((Mutation)p);
            interval = interval == smallInterval ? largeInterval : smallInterval;
            ts += interval;
            ++counter;
        }
        table.close();
    }

    public static void generateHBaseDatasetCompositeKeyInt(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        int startVal = 0;
        int stopVal = 1000;
        int interval = 47;
        long counter = 0L;
        int i = startVal;
        while (i < stopVal) {
            byte[] rowKey = ByteBuffer.allocate(12).putInt(i).array();
            for (int j = 0; j < 8; ++j) {
                rowKey[4 + j] = (byte)(counter >> 56 - j * 8);
            }
            Put p = new Put(rowKey);
            p.addColumn(FAMILY_F, COLUMN_C, "dummy".getBytes());
            table.mutate((Mutation)p);
            i += interval;
            ++counter;
        }
        table.close();
    }

    public static void generateHBaseDatasetDoubleOB(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (double i = 0.5; i <= 100.0; i += 0.75) {
            byte[] bytes = new byte[9];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 9);
            OrderedBytes.encodeFloat64((PositionedByteRange)br, (double)i, (Order)Order.ASCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %03f", i).getBytes());
            table.mutate((Mutation)p);
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetFloatOB(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        float i = 0.5f;
        while ((double)i <= 100.0) {
            byte[] bytes = new byte[5];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 5);
            OrderedBytes.encodeFloat32((PositionedByteRange)br, (float)i, (Order)Order.ASCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %03f", Float.valueOf(i)).getBytes());
            table.mutate((Mutation)p);
            i += 0.75f;
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetBigIntOB(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        long startTime;
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (long i = startTime = 1438034423000L; i <= startTime + 100L; ++i) {
            byte[] bytes = new byte[9];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 9);
            OrderedBytes.encodeInt64((PositionedByteRange)br, (long)i, (Order)Order.ASCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %d", i).getBytes());
            table.mutate((Mutation)p);
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetIntOB(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (int i = -49; i <= 100; ++i) {
            byte[] bytes = new byte[5];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 5);
            OrderedBytes.encodeInt32((PositionedByteRange)br, (int)i, (Order)Order.ASCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %d", i).getBytes());
            table.mutate((Mutation)p);
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetDoubleOBDesc(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (double i = 0.5; i <= 100.0; i += 0.75) {
            byte[] bytes = new byte[9];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 9);
            OrderedBytes.encodeFloat64((PositionedByteRange)br, (double)i, (Order)Order.DESCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %03f", i).getBytes());
            table.mutate((Mutation)p);
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetFloatOBDesc(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        float i = 0.5f;
        while ((double)i <= 100.0) {
            byte[] bytes = new byte[5];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 5);
            OrderedBytes.encodeFloat32((PositionedByteRange)br, (float)i, (Order)Order.DESCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %03f", Float.valueOf(i)).getBytes());
            table.mutate((Mutation)p);
            i += 0.75f;
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetBigIntOBDesc(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        long startTime;
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (long i = startTime = 1438034423000L; i <= startTime + 100L; ++i) {
            byte[] bytes = new byte[9];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 9);
            OrderedBytes.encodeInt64((PositionedByteRange)br, (long)i, (Order)Order.DESCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %d", i).getBytes());
            table.mutate((Mutation)p);
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetIntOBDesc(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY_F));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        for (int i = -49; i <= 100; ++i) {
            byte[] bytes = new byte[5];
            SimplePositionedMutableByteRange br = new SimplePositionedMutableByteRange(bytes, 0, 5);
            OrderedBytes.encodeInt32((PositionedByteRange)br, (int)i, (Order)Order.DESCENDING);
            Put p = new Put(bytes);
            p.addColumn(FAMILY_F, COLUMN_C, String.format("value %d", i).getBytes());
            table.mutate((Mutation)p);
        }
        table.close();
        admin.flush(tableName);
    }

    public static void generateHBaseDatasetNullStr(Connection conn, Admin admin, TableName tableName, int numberRegions) throws Exception {
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        if (numberRegions > 1) {
            admin.createTable(desc, (byte[][])Arrays.copyOfRange(SPLIT_KEYS, 0, numberRegions - 1));
        } else {
            admin.createTable(desc);
        }
        BufferedMutator table = conn.getBufferedMutator(tableName);
        Put p = new Put("a1".getBytes());
        p.addColumn("f".getBytes(), "c1".getBytes(), "".getBytes());
        p.addColumn("f".getBytes(), "c2".getBytes(), "".getBytes());
        p.addColumn("f".getBytes(), "c3".getBytes(), "5".getBytes());
        p.addColumn("f".getBytes(), "c4".getBytes(), "".getBytes());
        table.mutate((Mutation)p);
        table.close();
    }
}

