/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.util.regex.Pattern;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.hbase.HBaseRegexParser;
import org.apache.drill.test.DrillTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestHBaseRegexParser
extends DrillTest {
    @Test
    public void testLikeExprToRegex() throws Exception {
        HBaseRegexParser parser = new HBaseRegexParser("ABC%[0-7][0-9A-Fa-f]").parse();
        Assert.assertEquals((Object)"^\\QABC\\E.*[0-7][0-9A-Fa-f]$", (Object)parser.getRegexString());
        Assert.assertEquals((Object)"ABC", (Object)parser.getPrefixString());
        Pattern pattern = Pattern.compile(parser.getRegexString(), 32);
        Assert.assertTrue((boolean)pattern.matcher("ABC79").matches());
        Assert.assertTrue((boolean)pattern.matcher("ABCxxxxxxx79").matches());
        parser = new HBaseRegexParser("ABC%[0-8]%_").parse();
        Assert.assertEquals((Object)"^\\QABC\\E.*[0-8].*.$", (Object)parser.getRegexString());
        Assert.assertEquals((Object)"ABC", (Object)parser.getPrefixString());
        pattern = Pattern.compile(parser.getRegexString(), 32);
        Assert.assertTrue((boolean)pattern.matcher("ABC79").matches());
        Assert.assertTrue((boolean)pattern.matcher("ABCxxxx79").matches());
        Assert.assertTrue((boolean)pattern.matcher("ABCxxxx7xxxxx9").matches());
        Assert.assertTrue((boolean)pattern.matcher("ABC[0-8]_").matches());
        parser = new HBaseRegexParser("ABC%[0-8]%_", Character.valueOf('%')).parse();
        Assert.assertEquals((Object)"^\\QABC\\E\\Q[\\E\\Q0-8]\\E\\Q_\\E$", (Object)parser.getRegexString());
        Assert.assertEquals((Object)"ABC[0-8]_", (Object)parser.getPrefixString());
        pattern = Pattern.compile(parser.getRegexString(), 32);
        Assert.assertFalse((boolean)pattern.matcher("ABC79").matches());
        Assert.assertTrue((boolean)pattern.matcher("ABC[0-8]_").matches());
        try {
            parser = new HBaseRegexParser("ABC%[0-8][^a-f]%", Character.valueOf('%')).parse();
            Assert.fail((String)"Parsed an illegal LIKE expression.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

