/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.hbase.BaseHBaseTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestHBaseProjectPushDown
extends BaseHBaseTest {
    @Test
    public void testRowKeyPushDown() throws Exception {
        this.setColumnWidth(8);
        this.runHBaseSQLVerifyCount("SELECT\nrow_key\nFROM\n  hbase.`[TABLE_NAME]` tableName", 8);
    }

    @Test
    public void testColumnWith1RowPushDown() throws Exception {
        this.setColumnWidth(6);
        this.runHBaseSQLVerifyCount("SELECT\nt.f2.c7 as `t.f2.c7`\nFROM\n  hbase.`[TABLE_NAME]` t", 1);
    }

    @Test
    public void testRowKeyAndColumnPushDown() throws Exception {
        this.setColumnWidths(new int[]{8, 9, 6, 2, 6});
        this.runHBaseSQLVerifyCount("SELECT\nrow_key, t.f.c1 * 31 as `t dot f dot c1 * 31`, t.f.c2 as `t dot f dot c2`, 5 as `5`, 'abc' as `'abc'`\nFROM\n  hbase.`[TABLE_NAME]` t", 8);
    }

    @Test
    public void testColumnFamilyPushDown() throws Exception {
        this.setColumnWidths(new int[]{8, 74, 38});
        this.runHBaseSQLVerifyCount("SELECT\nrow_key, f, f2\nFROM\n  hbase.`[TABLE_NAME]` tableName", 8);
    }
}

