/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.hbase.HBaseGroupScan;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.drill.hbase.BaseHBaseTest;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestHBaseRegionScanAssignments
extends BaseHBaseTest {
    static final String HOST_A = "A";
    static final String HOST_B = "B";
    static final String HOST_C = "C";
    static final String HOST_D = "D";
    static final String HOST_E = "E";
    static final String HOST_F = "F";
    static final String HOST_G = "G";
    static final String HOST_H = "H";
    static final String HOST_I = "I";
    static final String HOST_J = "J";
    static final String HOST_K = "K";
    static final String HOST_L = "L";
    static final String HOST_M = "M";
    static final String HOST_X = "X";
    static final String PORT_AND_STARTTIME = ",60020,1400265190186";
    static final ServerName SERVER_A = ServerName.valueOf((String)"A,60020,1400265190186");
    static final ServerName SERVER_B = ServerName.valueOf((String)"B,60020,1400265190186");
    static final ServerName SERVER_C = ServerName.valueOf((String)"C,60020,1400265190186");
    static final ServerName SERVER_D = ServerName.valueOf((String)"D,60020,1400265190186");
    static final ServerName SERVER_E = ServerName.valueOf((String)"E,60020,1400265190186");
    static final ServerName SERVER_F = ServerName.valueOf((String)"F,60020,1400265190186");
    static final ServerName SERVER_G = ServerName.valueOf((String)"G,60020,1400265190186");
    static final ServerName SERVER_H = ServerName.valueOf((String)"H,60020,1400265190186");
    static final ServerName SERVER_I = ServerName.valueOf((String)"I,60020,1400265190186");
    static final ServerName SERVER_X = ServerName.valueOf((String)"X,60020,1400265190186");
    static final byte[][] splits = new byte[][]{new byte[0], "10".getBytes(), "15".getBytes(), "20".getBytes(), "25".getBytes(), "30".getBytes(), "35".getBytes(), "40".getBytes(), "45".getBytes(), "50".getBytes(), "55".getBytes(), "60".getBytes(), "65".getBytes(), "70".getBytes(), "75".getBytes(), "80".getBytes(), "85".getBytes(), "90".getBytes(), "95".getBytes()};
    static final String TABLE_NAME_STR = "TestTable";
    static final TableName TABLE_NAME = TableName.valueOf((String)"TestTable");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testHBaseGroupScanAssignmentMix() throws Exception {
        TreeMap regionsToScan = Maps.newTreeMap();
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[0], splits[1]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[1], splits[2]), SERVER_B);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[2], splits[3]), SERVER_B);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[3], splits[4]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[4], splits[5]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[5], splits[6]), SERVER_D);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[6], splits[7]), SERVER_C);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[7], splits[0]), SERVER_D);
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint DB_A = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build();
        endpoints.add(DB_A);
        endpoints.add(DB_A);
        CoordinationProtos.DrillbitEndpoint DB_B = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build();
        endpoints.add(DB_B);
        CoordinationProtos.DrillbitEndpoint DB_D = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build();
        endpoints.add(DB_D);
        CoordinationProtos.DrillbitEndpoint DB_X = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_X).setControlPort(1234).build();
        endpoints.add(DB_X);
        HBaseGroupScan scan = new HBaseGroupScan();
        scan.setRegionsToScan((NavigableMap)regionsToScan);
        scan.setHBaseScanSpec(new HBaseScanSpec(TABLE_NAME_STR, splits[0], splits[0], null));
        scan.applyAssignments((List)endpoints);
        int i = 0;
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        this.testParallelizationWidth(scan, i);
    }

    @Test
    public void testHBaseGroupScanAssignmentSomeAfinedWithOrphans() throws Exception {
        TreeMap regionsToScan = Maps.newTreeMap();
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[0], splits[1]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[1], splits[2]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[2], splits[3]), SERVER_B);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[3], splits[4]), SERVER_B);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[4], splits[5]), SERVER_C);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[5], splits[6]), SERVER_C);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[6], splits[7]), SERVER_D);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[7], splits[8]), SERVER_D);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[8], splits[9]), SERVER_E);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[9], splits[10]), SERVER_E);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[10], splits[11]), SERVER_F);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[11], splits[12]), SERVER_F);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[12], splits[13]), SERVER_G);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[13], splits[14]), SERVER_G);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[14], splits[15]), SERVER_H);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[15], splits[16]), SERVER_H);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[16], splits[17]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[17], splits[0]), SERVER_A);
        ArrayList endpoints = Lists.newArrayList();
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_C).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_E).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_F).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_G).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_H).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_I).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_J).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_K).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_L).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_M).setControlPort(1234).build());
        HBaseGroupScan scan = new HBaseGroupScan();
        scan.setRegionsToScan((NavigableMap)regionsToScan);
        scan.setHBaseScanSpec(new HBaseScanSpec(TABLE_NAME_STR, splits[0], splits[0], null));
        scan.applyAssignments((List)endpoints);
        LinkedList sizes = Lists.newLinkedList();
        Collections.addAll(sizes, 1, 1, 1, 1, 1, 1, 1, 1);
        Collections.addAll(sizes, 2, 2, 2, 2, 2);
        for (int i = 0; i < endpoints.size(); ++i) {
            Assert.assertTrue((boolean)sizes.remove((Object)scan.getSpecificScan(i).getRegionScanSpecList().size()));
        }
        Assert.assertEquals((long)0L, (long)sizes.size());
        this.testParallelizationWidth(scan, endpoints.size());
    }

    @Test
    public void testHBaseGroupScanAssignmentOneEach() throws Exception {
        TreeMap regionsToScan = Maps.newTreeMap();
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[0], splits[1]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[1], splits[2]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[2], splits[3]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[3], splits[4]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[4], splits[5]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[5], splits[6]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[6], splits[7]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[7], splits[8]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[8], splits[0]), SERVER_A);
        ArrayList endpoints = Lists.newArrayList();
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_C).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_E).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_F).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_G).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_H).setControlPort(1234).build());
        HBaseGroupScan scan = new HBaseGroupScan();
        scan.setRegionsToScan((NavigableMap)regionsToScan);
        scan.setHBaseScanSpec(new HBaseScanSpec(TABLE_NAME_STR, splits[0], splits[0], null));
        scan.applyAssignments((List)endpoints);
        int i = 0;
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        this.testParallelizationWidth(scan, i);
    }

    @Test
    public void testHBaseGroupScanAssignmentNoAfinity() throws Exception {
        TreeMap regionsToScan = Maps.newTreeMap();
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[0], splits[1]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[1], splits[2]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[2], splits[3]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[3], splits[4]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[4], splits[5]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[5], splits[6]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[6], splits[7]), SERVER_X);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[7], splits[0]), SERVER_X);
        ArrayList endpoints = Lists.newArrayList();
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_C).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_E).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_F).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_G).setControlPort(1234).build());
        endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_H).setControlPort(1234).build());
        HBaseGroupScan scan = new HBaseGroupScan();
        scan.setRegionsToScan((NavigableMap)regionsToScan);
        scan.setHBaseScanSpec(new HBaseScanSpec(TABLE_NAME_STR, splits[0], splits[0], null));
        scan.applyAssignments((List)endpoints);
        int i = 0;
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)1L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        this.testParallelizationWidth(scan, i);
    }

    @Test
    public void testHBaseGroupScanAssignmentAllPreferred() throws Exception {
        TreeMap regionsToScan = Maps.newTreeMap();
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[0], splits[1]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[1], splits[2]), SERVER_A);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[2], splits[3]), SERVER_B);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[3], splits[4]), SERVER_B);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[4], splits[5]), SERVER_C);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[5], splits[6]), SERVER_C);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[6], splits[7]), SERVER_D);
        regionsToScan.put(new HRegionInfo(TABLE_NAME, splits[7], splits[0]), SERVER_D);
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint DB_A = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build();
        endpoints.add(DB_A);
        CoordinationProtos.DrillbitEndpoint DB_B = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build();
        endpoints.add(DB_B);
        CoordinationProtos.DrillbitEndpoint DB_D = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_C).setControlPort(1234).build();
        endpoints.add(DB_D);
        CoordinationProtos.DrillbitEndpoint DB_X = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build();
        endpoints.add(DB_X);
        HBaseGroupScan scan = new HBaseGroupScan();
        scan.setRegionsToScan((NavigableMap)regionsToScan);
        scan.setHBaseScanSpec(new HBaseScanSpec(TABLE_NAME_STR, splits[0], splits[0], null));
        scan.applyAssignments((List)endpoints);
        int i = 0;
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        Assert.assertEquals((long)2L, (long)scan.getSpecificScan(i++).getRegionScanSpecList().size());
        this.testParallelizationWidth(scan, i);
    }

    private void testParallelizationWidth(HBaseGroupScan scan, int i) {
        try {
            scan.getSpecificScan(i);
            Assert.fail((String)("Should not have " + i + "th assignment or you have not enabled Java assertion."));
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }
}

