/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.planner.PhysicalPlanReaderTestFactory;
import org.apache.drill.exec.store.hbase.config.HBasePersistentStoreProvider;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.hbase.BaseHBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestHBaseTableProvider
extends BaseHBaseTest {
    @Parameterized.Parameter(value=0)
    public Supplier<HBasePersistentStoreProvider> providerSupplier;
    private HBasePersistentStoreProvider provider;

    @Parameterized.Parameters
    public static List<Supplier> providers() {
        return Arrays.asList(() -> new HBasePersistentStoreProvider(storagePluginConfig.getHBaseConf(), "drill_store"), () -> new HBasePersistentStoreProvider(storagePluginConfig.getHBaseConf(), "drill_store", "blob_drill_store"));
    }

    @Before
    public void setUpBeforeTestHBaseTableProvider() throws Exception {
        this.provider = this.providerSupplier.get();
        this.provider.start();
    }

    @Test
    public void testTableProvider() throws StoreException {
        LogicalPlanPersistence lp = PhysicalPlanReaderTestFactory.defaultLogicalPlanPersistence((DrillConfig)config);
        PersistentStore hbaseStore = this.provider.getOrCreateStore(PersistentStoreConfig.newJacksonBuilder((ObjectMapper)lp.getMapper(), String.class).name("hbase").build());
        hbaseStore.put("", (Object)"v0");
        hbaseStore.put("k1", (Object)"v1");
        hbaseStore.put("k2", (Object)"v2");
        hbaseStore.put("k3", (Object)"v3");
        hbaseStore.put("k4", (Object)"v4");
        hbaseStore.put("k5", (Object)"v5");
        hbaseStore.put(".test", (Object)"testValue");
        Assert.assertEquals((Object)"v0", (Object)hbaseStore.get(""));
        Assert.assertEquals((Object)"testValue", (Object)hbaseStore.get(".test"));
        Assert.assertTrue((boolean)hbaseStore.contains(""));
        Assert.assertFalse((boolean)hbaseStore.contains("unknown_key"));
        Assert.assertEquals((long)7L, (long)Lists.newArrayList((Iterator)hbaseStore.getAll()).size());
        PersistentStore hbaseTestStore = this.provider.getOrCreateStore(PersistentStoreConfig.newJacksonBuilder((ObjectMapper)lp.getMapper(), String.class).name("hbase.test").build());
        hbaseTestStore.put("", (Object)"v0");
        hbaseTestStore.put("k1", (Object)"v1");
        hbaseTestStore.put("k2", (Object)"v2");
        hbaseTestStore.put("k3", (Object)"v3");
        hbaseTestStore.put("k4", (Object)"v4");
        hbaseTestStore.put(".test", (Object)"testValue");
        Assert.assertEquals((Object)"v0", (Object)hbaseStore.get(""));
        Assert.assertEquals((Object)"testValue", (Object)hbaseStore.get(".test"));
        Assert.assertEquals((long)6L, (long)Lists.newArrayList((Iterator)hbaseTestStore.getAll()).size());
    }

    @After
    public void tearDownTestHBaseTableProvider() {
        if (this.provider != null) {
            this.provider.close();
        }
    }
}

