/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.categories.HbaseStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.io.Resources;
import org.apache.drill.test.BaseTestQuery;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, HbaseStorageTest.class})
public class TestOrderedBytesConvertFunctions
extends BaseTestQuery {
    private static final String CONVERSION_TEST_PHYSICAL_PLAN = "functions/conv/conversionTestWithPhysicalPlan.json";
    private static final float DELTA = 1.0E-4f;
    String textFileContent;

    @Test
    public void testOrderedBytesDouble() throws Throwable {
        this.verifyPhysicalPlan("convert_to(4.9e-324, 'DOUBLE_OB')", new byte[]{49, -128, 0, 0, 0, 0, 0, 0, 1});
    }

    @Test
    public void testOrderedBytesDoubleConvertFrom() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x31\\x80\\x00\\x00\\x00\\x00\\x00\\x00\\x01'), 'DOUBLE_OB')", Double.MIN_VALUE);
    }

    protected <T> void verifyPhysicalPlan(String expression, T expectedResults) throws Throwable {
        expression = expression.replace("\\", "\\\\\\\\");
        if (this.textFileContent == null) {
            this.textFileContent = Resources.toString((URL)Resources.getResource((String)CONVERSION_TEST_PHYSICAL_PLAN), (Charset)Charsets.UTF_8);
        }
        String planString = this.textFileContent.replace("__CONVERT_EXPRESSION__", expression);
        this.verifyResults(expression, expectedResults, this.getRunResult(UserBitShared.QueryType.PHYSICAL, planString));
    }

    protected Object[] getRunResult(UserBitShared.QueryType queryType, String planString) throws Exception {
        List resultList = TestOrderedBytesConvertFunctions.testRunAndReturn((UserBitShared.QueryType)queryType, (Object)planString);
        ArrayList<Object> res = new ArrayList<Object>();
        RecordBatchLoader loader = new RecordBatchLoader(TestOrderedBytesConvertFunctions.getAllocator());
        for (QueryDataBatch result : resultList) {
            if (result.getData() == null) continue;
            loader.load(result.getHeader().getDef(), result.getData());
            ValueVector v = ((VectorWrapper)loader.iterator().next()).getValueVector();
            for (int j = 0; j < v.getAccessor().getValueCount(); ++j) {
                if (v instanceof VarCharVector) {
                    res.add(new String(((VarCharVector)v).getAccessor().get(j)));
                    continue;
                }
                res.add(v.getAccessor().getObject(j));
            }
            loader.clear();
            result.release();
        }
        return res.toArray();
    }

    protected <T> void verifyResults(String expression, T expectedResults, Object[] actualResults) throws Throwable {
        String testName = String.format("Expression: %s.", expression);
        Assert.assertEquals((String)testName, (long)1L, (long)actualResults.length);
        Assert.assertNotNull((String)testName, (Object)actualResults[0]);
        if (expectedResults.getClass().isArray()) {
            this.assertArraysEquals(testName, expectedResults, actualResults[0]);
        } else {
            Assert.assertEquals((String)testName, expectedResults, (Object)actualResults[0]);
        }
    }

    protected void assertArraysEquals(Object expected, Object actual) {
        this.assertArraysEquals(null, expected, actual);
    }

    protected void assertArraysEquals(String message, Object expected, Object actual) {
        if (expected instanceof byte[] && actual instanceof byte[]) {
            Assert.assertArrayEquals((String)message, (byte[])((byte[])expected), (byte[])((byte[])actual));
        } else if (expected instanceof Object[] && actual instanceof Object[]) {
            Assert.assertArrayEquals((String)message, (Object[])((Object[])expected), (Object[])((Object[])actual));
        } else if (expected instanceof char[] && actual instanceof char[]) {
            Assert.assertArrayEquals((String)message, (char[])((char[])expected), (char[])((char[])actual));
        } else if (expected instanceof short[] && actual instanceof short[]) {
            Assert.assertArrayEquals((String)message, (short[])((short[])expected), (short[])((short[])actual));
        } else if (expected instanceof int[] && actual instanceof int[]) {
            Assert.assertArrayEquals((String)message, (int[])((int[])expected), (int[])((int[])actual));
        } else if (expected instanceof long[] && actual instanceof long[]) {
            Assert.assertArrayEquals((String)message, (long[])((long[])expected), (long[])((long[])actual));
        } else if (expected instanceof float[] && actual instanceof float[]) {
            Assert.assertArrayEquals((String)message, (float[])((float[])expected), (float[])((float[])actual), (float)1.0E-4f);
        } else if (expected instanceof double[] && actual instanceof double[]) {
            Assert.assertArrayEquals((String)message, (double[])((double[])expected), (double[])((double[])actual), (double)1.0E-4f);
        } else {
            Assert.fail((String)String.format("%s: Error comparing arrays of type '%s' and '%s'", expected.getClass().getName(), actual == null ? "null" : actual.getClass().getName()));
        }
    }
}

