/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hbase.HBaseStoragePlugin;
import org.apache.drill.exec.store.hbase.HBaseStoragePluginConfig;
import org.apache.drill.hbase.HBaseTestsSuite;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.io.Files;
import org.apache.drill.test.BaseTestQuery;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class BaseHBaseTest
extends BaseTestQuery {
    public static final String HBASE_STORAGE_PLUGIN_NAME = "hbase";
    protected static Configuration conf = HBaseConfiguration.create();
    protected static HBaseStoragePlugin storagePlugin;
    protected static HBaseStoragePluginConfig storagePluginConfig;

    @BeforeClass
    public static void setupDefaultTestCluster() throws Exception {
        HBaseTestsSuite.configure(true, true);
        HBaseTestsSuite.initCluster();
        BaseTestQuery.setupDefaultTestCluster();
        StoragePluginRegistry pluginRegistry = BaseHBaseTest.getDrillbitContext().getStorage();
        storagePlugin = (HBaseStoragePlugin)pluginRegistry.getPlugin(HBASE_STORAGE_PLUGIN_NAME);
        storagePluginConfig = storagePlugin.getConfig();
        storagePluginConfig.setEnabled(Boolean.valueOf(true));
        storagePluginConfig.setZookeeperPort(HBaseTestsSuite.getZookeeperPort());
        pluginRegistry.createOrUpdate(HBASE_STORAGE_PLUGIN_NAME, (StoragePluginConfig)storagePluginConfig, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        HBaseTestsSuite.tearDownCluster();
    }

    protected String getPlanText(String planFile, String tableName) throws IOException {
        return Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)planFile), (Charset)Charsets.UTF_8).read().replaceFirst("\"hbase\\.zookeeper\\.property\\.clientPort\".*:.*\\d+", "\"hbase.zookeeper.property.clientPort\" : " + HBaseTestsSuite.getZookeeperPort()).replace("[TABLE_NAME]", tableName);
    }

    protected void runHBasePhysicalVerifyCount(String planFile, String tableName, int expectedRowCount) throws Exception {
        String physicalPlan = this.getPlanText(planFile, tableName);
        List results = BaseHBaseTest.testPhysicalWithResults((String)physicalPlan);
        this.logResultAndVerifyRowCount(results, expectedRowCount);
    }

    protected List<QueryDataBatch> runHBaseSQLlWithResults(String sql) throws Exception {
        sql = this.canonizeHBaseSQL(sql);
        return BaseHBaseTest.testSqlWithResults((String)sql);
    }

    protected void runHBaseSQLVerifyCount(String sql, int expectedRowCount) throws Exception {
        List<QueryDataBatch> results = this.runHBaseSQLlWithResults(sql);
        this.logResultAndVerifyRowCount(results, expectedRowCount);
    }

    private void logResultAndVerifyRowCount(List<QueryDataBatch> results, int expectedRowCount) throws SchemaChangeException {
        int rowCount = this.logResult(results);
        if (expectedRowCount != -1) {
            Assert.assertEquals((long)expectedRowCount, (long)rowCount);
        }
    }

    protected String canonizeHBaseSQL(String sql) {
        return sql.replace("[TABLE_NAME]", HBaseTestsSuite.TEST_TABLE_1.getNameAsString());
    }
}

