/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.hbase;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.ZookeeperTestUtil;
import org.apache.drill.exec.util.GuavaPatcher;
import org.apache.drill.hbase.HBaseRecordReaderTest;
import org.apache.drill.hbase.TestHBaseCFAsJSONString;
import org.apache.drill.hbase.TestHBaseConnectionManager;
import org.apache.drill.hbase.TestHBaseFilterPushDown;
import org.apache.drill.hbase.TestHBaseProjectPushDown;
import org.apache.drill.hbase.TestHBaseQueries;
import org.apache.drill.hbase.TestHBaseRegexParser;
import org.apache.drill.hbase.TestHBaseRegionScanAssignments;
import org.apache.drill.hbase.TestHBaseTableProvider;
import org.apache.drill.hbase.TestOrderedBytesConvertFunctions;
import org.apache.drill.hbase.TestTableGenerator;
import org.apache.drill.hbase.test.Drill2130StorageHBaseHamcrestConfigurationTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={Drill2130StorageHBaseHamcrestConfigurationTest.class, HBaseRecordReaderTest.class, TestHBaseCFAsJSONString.class, TestHBaseConnectionManager.class, TestHBaseFilterPushDown.class, TestHBaseProjectPushDown.class, TestHBaseQueries.class, TestHBaseRegexParser.class, TestHBaseRegionScanAssignments.class, TestHBaseTableProvider.class, TestOrderedBytesConvertFunctions.class})
public class HBaseTestsSuite {
    static final Logger logger = LoggerFactory.getLogger(HBaseTestsSuite.class);
    private static final boolean IS_DEBUG;
    protected static final TableName TEST_TABLE_1;
    protected static final TableName TEST_TABLE_2;
    protected static final TableName TEST_TABLE_3;
    protected static final TableName TEST_TABLE_MULTI_CF_DIFFERENT_CASE;
    protected static final TableName TEST_TABLE_COMPOSITE_DATE;
    protected static final TableName TEST_TABLE_COMPOSITE_TIME;
    protected static final TableName TEST_TABLE_COMPOSITE_INT;
    protected static final TableName TEST_TABLE_DOUBLE_OB;
    protected static final TableName TEST_TABLE_FLOAT_OB;
    protected static final TableName TEST_TABLE_BIGINT_OB;
    protected static final TableName TEST_TABLE_INT_OB;
    protected static final TableName TEST_TABLE_DOUBLE_OB_DESC;
    protected static final TableName TEST_TABLE_FLOAT_OB_DESC;
    protected static final TableName TEST_TABLE_BIGINT_OB_DESC;
    protected static final TableName TEST_TABLE_INT_OB_DESC;
    protected static final TableName TEST_TABLE_NULL_STR;
    private static Configuration conf;
    private static Connection conn;
    private static Admin admin;
    private static HBaseTestingUtility UTIL;
    private static volatile AtomicInteger initCount;
    private static boolean manageHBaseCluster;
    private static boolean hbaseClusterCreated;
    private static boolean createTables;
    private static boolean tablesCreated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @BeforeClass
    public static void initCluster() throws Exception {
        ZookeeperTestUtil.setJaasTestConfigFile();
        if (initCount.get() == 0) {
            Class<HBaseTestsSuite> clazz = HBaseTestsSuite.class;
            // MONITORENTER : org.apache.drill.hbase.HBaseTestsSuite.class
            if (initCount.get() == 0) {
                conf = HBaseConfiguration.create();
                conf.set("hbase.client.instance.id", "drill-hbase-unit-tests-client");
                if (IS_DEBUG) {
                    conf.set("hbase.client.scanner.timeout.period", "10000000");
                }
                if (manageHBaseCluster) {
                    logger.info("Starting HBase mini cluster.");
                    UTIL = new HBaseTestingUtility(conf);
                    UTIL.startMiniZKCluster();
                    String old_home = System.getProperty("user.home");
                    System.setProperty("user.home", UTIL.getDataTestDir().toString());
                    UTIL.startMiniHBaseCluster(1, 1);
                    System.setProperty("user.home", old_home);
                    hbaseClusterCreated = true;
                    logger.info("HBase mini cluster started. Zookeeper port: '{}'", (Object)HBaseTestsSuite.getZookeeperPort());
                }
                conn = ConnectionFactory.createConnection((Configuration)conf);
                admin = conn.getAdmin();
                if (createTables || !HBaseTestsSuite.tablesExist()) {
                    HBaseTestsSuite.createTestTables();
                    tablesCreated = true;
                }
                initCount.incrementAndGet();
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        initCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() throws Exception {
        Class<HBaseTestsSuite> clazz = HBaseTestsSuite.class;
        synchronized (HBaseTestsSuite.class) {
            if (initCount.decrementAndGet() == 0) {
                if (createTables && tablesCreated) {
                    HBaseTestsSuite.cleanupTestTables();
                }
                if (admin != null) {
                    admin.close();
                }
                if (hbaseClusterCreated) {
                    logger.info("Shutting down HBase mini cluster.");
                    UTIL.shutdownMiniCluster();
                    logger.info("HBase mini cluster stopped.");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Configuration getConf() {
        return conf;
    }

    public static HBaseTestingUtility getHBaseTestingUtility() {
        return UTIL;
    }

    private static boolean tablesExist() throws IOException {
        return admin.tableExists(TEST_TABLE_1) && admin.tableExists(TEST_TABLE_2) && admin.tableExists(TEST_TABLE_3) && admin.tableExists(TEST_TABLE_MULTI_CF_DIFFERENT_CASE) && admin.tableExists(TEST_TABLE_COMPOSITE_DATE) && admin.tableExists(TEST_TABLE_COMPOSITE_TIME) && admin.tableExists(TEST_TABLE_COMPOSITE_INT) && admin.tableExists(TEST_TABLE_DOUBLE_OB) && admin.tableExists(TEST_TABLE_FLOAT_OB) && admin.tableExists(TEST_TABLE_BIGINT_OB) && admin.tableExists(TEST_TABLE_INT_OB) && admin.tableExists(TEST_TABLE_DOUBLE_OB_DESC) && admin.tableExists(TEST_TABLE_FLOAT_OB_DESC) && admin.tableExists(TEST_TABLE_BIGINT_OB_DESC) && admin.tableExists(TEST_TABLE_INT_OB_DESC) && admin.tableExists(TEST_TABLE_NULL_STR);
    }

    private static void createTestTables() throws Exception {
        TestTableGenerator.generateHBaseDataset1(conn, admin, TEST_TABLE_1, 2);
        TestTableGenerator.generateHBaseDatasetSingleSchema(conn, admin, TEST_TABLE_2, 1);
        TestTableGenerator.generateHBaseDataset3(conn, admin, TEST_TABLE_3, 1);
        TestTableGenerator.generateHBaseDatasetMultiCF(conn, admin, TEST_TABLE_MULTI_CF_DIFFERENT_CASE, 1);
        TestTableGenerator.generateHBaseDatasetCompositeKeyDate(conn, admin, TEST_TABLE_COMPOSITE_DATE, 1);
        TestTableGenerator.generateHBaseDatasetCompositeKeyTime(conn, admin, TEST_TABLE_COMPOSITE_TIME, 1);
        TestTableGenerator.generateHBaseDatasetCompositeKeyInt(conn, admin, TEST_TABLE_COMPOSITE_INT, 1);
        TestTableGenerator.generateHBaseDatasetDoubleOB(conn, admin, TEST_TABLE_DOUBLE_OB, 1);
        TestTableGenerator.generateHBaseDatasetFloatOB(conn, admin, TEST_TABLE_FLOAT_OB, 1);
        TestTableGenerator.generateHBaseDatasetBigIntOB(conn, admin, TEST_TABLE_BIGINT_OB, 1);
        TestTableGenerator.generateHBaseDatasetIntOB(conn, admin, TEST_TABLE_INT_OB, 1);
        TestTableGenerator.generateHBaseDatasetDoubleOBDesc(conn, admin, TEST_TABLE_DOUBLE_OB_DESC, 1);
        TestTableGenerator.generateHBaseDatasetFloatOBDesc(conn, admin, TEST_TABLE_FLOAT_OB_DESC, 1);
        TestTableGenerator.generateHBaseDatasetBigIntOBDesc(conn, admin, TEST_TABLE_BIGINT_OB_DESC, 1);
        TestTableGenerator.generateHBaseDatasetIntOBDesc(conn, admin, TEST_TABLE_INT_OB_DESC, 1);
        TestTableGenerator.generateHBaseDatasetNullStr(conn, admin, TEST_TABLE_NULL_STR, 1);
    }

    private static void cleanupTestTables() throws IOException {
        admin.disableTable(TEST_TABLE_1);
        admin.deleteTable(TEST_TABLE_1);
        admin.disableTable(TEST_TABLE_2);
        admin.deleteTable(TEST_TABLE_2);
        admin.disableTable(TEST_TABLE_3);
        admin.deleteTable(TEST_TABLE_3);
        admin.disableTable(TEST_TABLE_MULTI_CF_DIFFERENT_CASE);
        admin.deleteTable(TEST_TABLE_MULTI_CF_DIFFERENT_CASE);
        admin.disableTable(TEST_TABLE_COMPOSITE_DATE);
        admin.deleteTable(TEST_TABLE_COMPOSITE_DATE);
        admin.disableTable(TEST_TABLE_COMPOSITE_TIME);
        admin.deleteTable(TEST_TABLE_COMPOSITE_TIME);
        admin.disableTable(TEST_TABLE_COMPOSITE_INT);
        admin.deleteTable(TEST_TABLE_COMPOSITE_INT);
        admin.disableTable(TEST_TABLE_DOUBLE_OB);
        admin.deleteTable(TEST_TABLE_DOUBLE_OB);
        admin.disableTable(TEST_TABLE_FLOAT_OB);
        admin.deleteTable(TEST_TABLE_FLOAT_OB);
        admin.disableTable(TEST_TABLE_BIGINT_OB);
        admin.deleteTable(TEST_TABLE_BIGINT_OB);
        admin.disableTable(TEST_TABLE_INT_OB);
        admin.deleteTable(TEST_TABLE_INT_OB);
        admin.disableTable(TEST_TABLE_DOUBLE_OB_DESC);
        admin.deleteTable(TEST_TABLE_DOUBLE_OB_DESC);
        admin.disableTable(TEST_TABLE_FLOAT_OB_DESC);
        admin.deleteTable(TEST_TABLE_FLOAT_OB_DESC);
        admin.disableTable(TEST_TABLE_BIGINT_OB_DESC);
        admin.deleteTable(TEST_TABLE_BIGINT_OB_DESC);
        admin.disableTable(TEST_TABLE_INT_OB_DESC);
        admin.deleteTable(TEST_TABLE_INT_OB_DESC);
        admin.disableTable(TEST_TABLE_NULL_STR);
        admin.deleteTable(TEST_TABLE_NULL_STR);
    }

    public static int getZookeeperPort() {
        return HBaseTestsSuite.getConf().getInt("hbase.zookeeper.property.clientPort", 2181);
    }

    public static void configure(boolean manageHBaseCluster, boolean createTables) {
        HBaseTestsSuite.manageHBaseCluster = manageHBaseCluster;
        HBaseTestsSuite.createTables = createTables;
    }

    public static Admin getAdmin() {
        return admin;
    }

    public static Connection getConnection() {
        return conn;
    }

    static {
        GuavaPatcher.patch();
        IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        TEST_TABLE_1 = TableName.valueOf((String)"TestTable1");
        TEST_TABLE_2 = TableName.valueOf((String)"TestTable2");
        TEST_TABLE_3 = TableName.valueOf((String)"TestTable3");
        TEST_TABLE_MULTI_CF_DIFFERENT_CASE = TableName.valueOf((String)"TestTableMultiCF");
        TEST_TABLE_COMPOSITE_DATE = TableName.valueOf((String)"TestTableCompositeDate");
        TEST_TABLE_COMPOSITE_TIME = TableName.valueOf((String)"TestTableCompositeTime");
        TEST_TABLE_COMPOSITE_INT = TableName.valueOf((String)"TestTableCompositeInt");
        TEST_TABLE_DOUBLE_OB = TableName.valueOf((String)"TestTableDoubleOB");
        TEST_TABLE_FLOAT_OB = TableName.valueOf((String)"TestTableFloatOB");
        TEST_TABLE_BIGINT_OB = TableName.valueOf((String)"TestTableBigIntOB");
        TEST_TABLE_INT_OB = TableName.valueOf((String)"TestTableIntOB");
        TEST_TABLE_DOUBLE_OB_DESC = TableName.valueOf((String)"TestTableDoubleOBDesc");
        TEST_TABLE_FLOAT_OB_DESC = TableName.valueOf((String)"TestTableFloatOBDesc");
        TEST_TABLE_BIGINT_OB_DESC = TableName.valueOf((String)"TestTableBigIntOBDesc");
        TEST_TABLE_INT_OB_DESC = TableName.valueOf((String)"TestTableIntOBDesc");
        TEST_TABLE_NULL_STR = TableName.valueOf((String)"TestTableNullStr");
        initCount = new AtomicInteger(0);
        manageHBaseCluster = System.getProperty("drill.hbase.tests.manageHBaseCluster", "true").equalsIgnoreCase("true");
        hbaseClusterCreated = false;
        createTables = System.getProperty("drill.hbase.tests.createTables", "true").equalsIgnoreCase("true");
        tablesCreated = false;
    }
}

