/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.googlesheets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsStoragePlugin;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsStoragePluginConfig;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Requires live connection to Google Sheets.  Please run tests manually.")
public class TestGoogleSheetsQueries
extends ClusterTest {
    private static final String AUTH_URI = "https://accounts.google.com/o/oauth2/auth";
    private static final String TOKEN_URI = "https://oauth2.googleapis.com/token";
    private static final List<String> REDIRECT_URI = new ArrayList<String>(Arrays.asList("urn:ietf:wg:oauth:2.0:oob", "http://localhost"));
    private static StoragePluginRegistry pluginRegistry;
    private static String accessToken;
    private static String refreshToken;
    private static String sheetID;
    private static String clientID;
    private static String clientSecret;

    @BeforeClass
    public static void init() throws Exception {
        String oauthJson = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/tokens/oauth_tokens.json"), (Charset)Charsets.UTF_8).read();
        ObjectMapper mapper = JacksonUtils.createObjectMapper();
        Map tokenMap = (Map)mapper.readValue(oauthJson, Map.class);
        clientID = (String)tokenMap.get("client_id");
        clientSecret = (String)tokenMap.get("client_secret");
        accessToken = (String)tokenMap.get("access_token");
        refreshToken = (String)tokenMap.get("refresh_token");
        sheetID = (String)tokenMap.get("sheet_id");
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true);
        TestGoogleSheetsQueries.startCluster((ClusterFixtureBuilder)builder);
        pluginRegistry = cluster.drillbit().getContext().getStorage();
        GoogleSheetsStoragePluginConfig config = GoogleSheetsStoragePluginConfig.builder().clientID(clientID).clientSecret(clientSecret).redirectUris(REDIRECT_URI).authUri(AUTH_URI).tokenUri(TOKEN_URI).allTextMode(Boolean.valueOf(false)).extractHeaders(Boolean.valueOf(true)).build();
        config.setEnabled(Boolean.valueOf(true));
        pluginRegistry.validatedPut("googlesheets", (StoragePluginConfig)config);
    }

    @Test
    public void testStarQuery() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM googlesheets.`%s`.`MixedSheet` WHERE `Col2` < 6.0", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.FLOAT8).addNullable("Col3", TypeProtos.MinorType.DATE).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", 1.0, null}).addRow(new Object[]{"Abdolhossein  Detlev", 2.0001, LocalDate.parse("2020-04-30")}).addRow(new Object[]{null, 4.0, LocalDate.parse("2020-06-30")}).addRow(new Object[]{"Yunus  Elena", 3.5, LocalDate.parse("2021-01-15")}).addRow(new Object[]{"Swaran  Ohiyesa", -63.8, LocalDate.parse("2021-04-08")}).addRow(new Object[]{"Kalani  Godabert", 0.0, LocalDate.parse("2021-06-28")}).addRow(new Object[]{"Caishen  Origenes", 5.0E-7, LocalDate.parse("2021-07-09")}).addRow(new Object[]{"Toufik  Gurgen", 2.0, LocalDate.parse("2021-11-05")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testStarQueryWithTabs() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM googlesheets.`%s`.`tab[1]` WHERE `Col2` < 6.0", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.FLOAT8).addNullable("Col3", TypeProtos.MinorType.DATE).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", 1.0, null}).addRow(new Object[]{"Abdolhossein  Detlev", 2.0001, LocalDate.parse("2020-04-30")}).addRow(new Object[]{null, 4.0, LocalDate.parse("2020-06-30")}).addRow(new Object[]{"Yunus  Elena", 3.5, LocalDate.parse("2021-01-15")}).addRow(new Object[]{"Swaran  Ohiyesa", -63.8, LocalDate.parse("2021-04-08")}).addRow(new Object[]{"Kalani  Godabert", 0.0, LocalDate.parse("2021-06-28")}).addRow(new Object[]{"Caishen  Origenes", 5.0E-7, LocalDate.parse("2021-07-09")}).addRow(new Object[]{"Toufik  Gurgen", 2.0, LocalDate.parse("2021-11-05")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSchemataInformationSchema() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = "SELECT * FROM `INFORMATION_SCHEMA`.`SCHEMATA` WHERE SCHEMA_NAME LIKE 'googlesheets.%'";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        Assert.assertTrue((results.rowCount() > 1 ? 1 : 0) != 0);
        results.clear();
    }

    @Test
    public void testTablesInfoSchema() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = "SELECT * FROM `INFORMATION_SCHEMA`.`TABLES` WHERE TABLE_SCHEMA LIKE 'googlesheets.%'";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)0L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testImplicitFields() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT _sheets, _title FROM googlesheets.`%s`.`MixedSheet` LIMIT 1", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addArray("_sheets", TypeProtos.MinorType.VARCHAR).addNullable("_title", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"TestSheet1", "MixedSheet"}), "Drill Test Data"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testImplicitFieldsWithTabs() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT _sheets FROM googlesheets.`%s`.`tab[1]` LIMIT 1", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addArray("_sheets", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"TestSheet1", "MixedSheet"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Ignore(value="Implicit columns have some projection issues. See DRILL-7080.  Once this is resolved, re-enable this test.")
    @Test
    public void testStarAndImplicitFields() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT *, _sheets FROM googlesheets.`%s`.`MixedSheet` LIMIT 3", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.FLOAT8).addNullable("Col3", TypeProtos.MinorType.DATE).addArray("_sheets", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", 1.0, null, RowSetUtilities.strArray((String[])new String[]{"TestSheet1", "MixedSheet"})}).addRow(new Object[]{"Abdolhossein  Detlev", 2.0001, LocalDate.parse("2020-04-30"), RowSetUtilities.strArray((String[])new String[]{"TestSheet1", "MixedSheet"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitAndImplicitFields() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT Col1, Col3, _sheets FROM googlesheets.`%s`.`MixedSheet` LIMIT 3", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col3", TypeProtos.MinorType.DATE).addArray("_sheets", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", null, RowSetUtilities.strArray((String[])new String[]{"TestSheet1", "MixedSheet"})}).addRow(new Object[]{"Abdolhossein  Detlev", LocalDate.parse("2020-04-30"), RowSetUtilities.strArray((String[])new String[]{"TestSheet1", "MixedSheet"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testProjectPushdown() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT Col1, Col3 FROM googlesheets.`%s`.`MixedSheet` LIMIT 5", sheetID);
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Project", "columns=\\[`Col1`, `Col3`\\]", "Limit", "maxRecords=5"}).match();
    }

    @Test
    public void testWithExplicitColumns() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT Col1, Col3 FROM googlesheets.`%s`.`MixedSheet` WHERE `Col2` < 6.0", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col3", TypeProtos.MinorType.DATE).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", null}).addRow(new Object[]{"Abdolhossein  Detlev", LocalDate.parse("2020-04-30")}).addRow(new Object[]{null, LocalDate.parse("2020-06-30")}).addRow(new Object[]{"Yunus  Elena", LocalDate.parse("2021-01-15")}).addRow(new Object[]{"Swaran  Ohiyesa", LocalDate.parse("2021-04-08")}).addRow(new Object[]{"Kalani  Godabert", LocalDate.parse("2021-06-28")}).addRow(new Object[]{"Caishen  Origenes", LocalDate.parse("2021-07-09")}).addRow(new Object[]{"Toufik  Gurgen", LocalDate.parse("2021-11-05")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testInvalidTab() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            String sql = String.format("SELECT * FROM googlesheets.`%s`.`tab[5]` WHERE `Col2` < 6.0", sheetID);
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Tab not found at index 5"));
        }
    }

    @Test
    public void testWithExplicitColumnsWithTab() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT Col1, Col3 FROM googlesheets.`%s`.`tab[1]` WHERE `Col2` < 6.0", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col3", TypeProtos.MinorType.DATE).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", null}).addRow(new Object[]{"Abdolhossein  Detlev", LocalDate.parse("2020-04-30")}).addRow(new Object[]{null, LocalDate.parse("2020-06-30")}).addRow(new Object[]{"Yunus  Elena", LocalDate.parse("2021-01-15")}).addRow(new Object[]{"Swaran  Ohiyesa", LocalDate.parse("2021-04-08")}).addRow(new Object[]{"Kalani  Godabert", LocalDate.parse("2021-06-28")}).addRow(new Object[]{"Caishen  Origenes", LocalDate.parse("2021-07-09")}).addRow(new Object[]{"Toufik  Gurgen", LocalDate.parse("2021-11-05")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testWithExplicitColumnsInDifferentOrder() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT Col3, Col1 FROM googlesheets.`%s`.`MixedSheet` WHERE `Col2` < 6.0", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col3", TypeProtos.MinorType.DATE).addNullable("Col1", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{null, "Rosaline  Thales"}).addRow(new Object[]{LocalDate.parse("2020-04-30"), "Abdolhossein  Detlev"}).addRow(new Object[]{LocalDate.parse("2020-06-30"), null}).addRow(new Object[]{LocalDate.parse("2021-01-15"), "Yunus  Elena"}).addRow(new Object[]{LocalDate.parse("2021-04-08"), "Swaran  Ohiyesa"}).addRow(new Object[]{LocalDate.parse("2021-06-28"), "Kalani  Godabert"}).addRow(new Object[]{LocalDate.parse("2021-07-09"), "Caishen  Origenes"}).addRow(new Object[]{LocalDate.parse("2021-11-05"), "Toufik  Gurgen"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testAggregateQuery() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT EXTRACT(YEAR FROM Col3) AS event_year, COUNT(*) AS event_count FROM googlesheets.`%s`.`MixedSheet` GROUP BY event_year", sheetID);
        List results = this.queryBuilder().sql(sql).results();
        for (QueryDataBatch b : results) {
            b.release();
        }
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void testSerDe() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT COUNT(*) FROM googlesheets.`%s`.`MixedSheet`", sheetID);
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)25L, (long)cnt);
    }

    @Test
    public void testAllTextMode() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        GoogleSheetsStoragePluginConfig config = GoogleSheetsStoragePluginConfig.builder().clientID(clientID).clientSecret(clientSecret).redirectUris(REDIRECT_URI).authUri(AUTH_URI).tokenUri(TOKEN_URI).allTextMode(Boolean.valueOf(true)).extractHeaders(Boolean.valueOf(true)).build();
        config.setEnabled(Boolean.valueOf(true));
        pluginRegistry.validatedPut("googlesheets", (StoragePluginConfig)config);
        String sql = String.format("SELECT * FROM googlesheets.`%s`.`MixedSheet` LIMIT 5", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.VARCHAR).addNullable("Col3", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", "1", null}).addRow(new Object[]{"Abdolhossein  Detlev", "2.0001", "2020-04-30"}).addRow(new Object[]{"Yosuke  Simon", null, "2020-05-22"}).addRow(new Object[]{null, "4", "2020-06-30"}).addRow(new Object[]{"Avitus  Stribog", "5.00E+05", "2020-07-27"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
        config = GoogleSheetsStoragePluginConfig.builder().clientID(clientID).clientSecret(clientSecret).redirectUris(REDIRECT_URI).authUri(AUTH_URI).tokenUri(TOKEN_URI).allTextMode(Boolean.valueOf(false)).extractHeaders(Boolean.valueOf(true)).build();
        config.setEnabled(Boolean.valueOf(true));
        pluginRegistry.validatedPut("googlesheets", (StoragePluginConfig)config);
    }

    @Test
    public void testSchemaProvisioning() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM table(`googlesheets`.`%s`.`MixedSheet` (schema => 'inline=(`Col1` VARCHAR, `Col2` INTEGER, `Col3` VARCHAR)')) LIMIT 5", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.INT).addNullable("Col3", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", 1, null}).addRow(new Object[]{"Abdolhossein  Detlev", 2, "2020-04-30"}).addRow(new Object[]{"Yosuke  Simon", null, "2020-05-22"}).addRow(new Object[]{null, 4, "2020-06-30"}).addRow(new Object[]{"Avitus  Stribog", 500000, "2020-07-27"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSchemaProvisioningWithTab() throws Exception {
        try {
            this.initializeTokens("googlesheets");
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM table(`googlesheets`.`%s`.`tab[1]` (schema => 'inline=(`Col1` VARCHAR, `Col2` INTEGER, `Col3` VARCHAR)')) LIMIT 5", sheetID);
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.INT).addNullable("Col3", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"Rosaline  Thales", 1, null}).addRow(new Object[]{"Abdolhossein  Detlev", 2, "2020-04-30"}).addRow(new Object[]{"Yosuke  Simon", null, "2020-05-22"}).addRow(new Object[]{null, 4, "2020-06-30"}).addRow(new Object[]{"Avitus  Stribog", 500000, "2020-07-27"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    private void initializeTokens(String pluginName) throws StoragePluginRegistry.PluginException {
        GoogleSheetsStoragePlugin plugin = (GoogleSheetsStoragePlugin)pluginRegistry.getPlugin(pluginName);
        plugin.initializeTokenTableForTesting();
        PersistentTokenTable tokenTable = plugin.getTokenTable();
        tokenTable.setAccessToken(accessToken);
        tokenTable.setRefreshToken(refreshToken);
        tokenTable.setExpiresIn("50000");
    }
}

