/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.googlesheets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsColumn;
import org.apache.drill.exec.store.googlesheets.utils.GoogleSheetsUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestGoogleSheetUtils {
    @Test
    public void testSchemaInference() {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        ArrayList<Object> row = new ArrayList<String>(Arrays.asList("Col1", "Col2", "Col3"));
        SchemaPath sp = new SchemaPath(SchemaPath.parseFromString((String)"Col1"));
        ArrayList<SchemaPath> projectedColumns = new ArrayList<SchemaPath>(Arrays.asList(new SchemaPath(SchemaPath.parseFromString((String)"Col1")), new SchemaPath(SchemaPath.parseFromString((String)"Col2")), new SchemaPath(SchemaPath.parseFromString((String)"Col3"))));
        data.add(row);
        row = new ArrayList<Serializable>(Arrays.asList("Rosaline Thales", 1));
        data.add(row);
        row = new ArrayList<String>(Arrays.asList("Abdolhossein Detlev", "2.0001", "2020-04-30"));
        data.add(row);
        row = new ArrayList<String>(Arrays.asList("Yosuke  Simon", "", "2020-05-22"));
        data.add(row);
        row = new ArrayList<String>(Arrays.asList("", "4", "2020-06-30"));
        data.add(row);
        Map columnMap = GoogleSheetsUtils.getColumnMap(data, projectedColumns, (boolean)false);
        Assert.assertEquals((long)3L, (long)columnMap.size());
        Assert.assertEquals((Object)TypeProtos.MinorType.VARCHAR, (Object)((GoogleSheetsColumn)columnMap.get("Col1")).getDrillDataType());
        Assert.assertEquals((Object)TypeProtos.MinorType.FLOAT8, (Object)((GoogleSheetsColumn)columnMap.get("Col2")).getDrillDataType());
        Assert.assertEquals((Object)TypeProtos.MinorType.DATE, (Object)((GoogleSheetsColumn)columnMap.get("Col3")).getDrillDataType());
    }

    @Test
    public void testBuildSchema() {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        ArrayList<SchemaPath> projectedColumns = new ArrayList<SchemaPath>(Arrays.asList(new SchemaPath(SchemaPath.parseFromString((String)"Col1")), new SchemaPath(SchemaPath.parseFromString((String)"Col2")), new SchemaPath(SchemaPath.parseFromString((String)"Col3"))));
        ArrayList<Object> row = new ArrayList<String>(Arrays.asList("Col1", "Col2", "Col3"));
        data.add(row);
        row = new ArrayList<Serializable>(Arrays.asList("Rosaline Thales", 1));
        data.add(row);
        row = new ArrayList<String>(Arrays.asList("Abdolhossein Detlev", "2.0001", "2020-04-30"));
        data.add(row);
        row = new ArrayList<String>(Arrays.asList("Yosuke  Simon", "", "2020-05-22"));
        data.add(row);
        row = new ArrayList<String>(Arrays.asList("", "4", "2020-06-30"));
        data.add(row);
        Map columnMap = GoogleSheetsUtils.getColumnMap(data, projectedColumns, (boolean)false);
        TupleMetadata actualSchema = GoogleSheetsUtils.buildSchema((Map)columnMap);
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("Col1", TypeProtos.MinorType.VARCHAR).addNullable("Col2", TypeProtos.MinorType.FLOAT8).addNullable("Col3", TypeProtos.MinorType.DATE).build();
        Assert.assertEquals((Object)actualSchema, (Object)expectedSchema);
    }

    @Test
    public void testColumnProjector() {
        LinkedHashMap<String, GoogleSheetsColumn> columnMap = new LinkedHashMap<String, GoogleSheetsColumn>();
        columnMap.put("f1", new GoogleSheetsColumn("f1", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 0, 0));
        columnMap.put("f2", new GoogleSheetsColumn("f2", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 1, 1));
        columnMap.put("f3", new GoogleSheetsColumn("f3", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 2, 2));
        columnMap.put("f4", new GoogleSheetsColumn("f4", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 3, 3));
        columnMap.put("f6", new GoogleSheetsColumn("f6", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 5, 4));
        columnMap.put("f9", new GoogleSheetsColumn("f9", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 8, 5));
        columnMap.put("f10", new GoogleSheetsColumn("f10", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 9, 6));
        List results = GoogleSheetsUtils.getProjectedRanges((String)"Sheet1", columnMap);
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void testColumnProjectorWithSingleColumns() {
        LinkedHashMap<String, GoogleSheetsColumn> columnMap = new LinkedHashMap<String, GoogleSheetsColumn>();
        columnMap.put("f1", new GoogleSheetsColumn("f1", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 0, 0));
        columnMap.put("f2", new GoogleSheetsColumn("f2", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 2, 1));
        columnMap.put("f3", new GoogleSheetsColumn("f3", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 4, 2));
        columnMap.put("f4", new GoogleSheetsColumn("f4", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 6, 3));
        columnMap.put("f6", new GoogleSheetsColumn("f6", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 7, 4));
        columnMap.put("f9", new GoogleSheetsColumn("f9", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 8, 5));
        columnMap.put("f10", new GoogleSheetsColumn("f10", GoogleSheetsUtils.DATA_TYPES.UNKNOWN, 9, 6));
        List results = GoogleSheetsUtils.getProjectedRanges((String)"Sheet1", columnMap);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void testColumnConversion() {
        Assert.assertEquals((Object)"A", (Object)GoogleSheetsUtils.columnToLetter((int)1));
        Assert.assertEquals((Object)"B", (Object)GoogleSheetsUtils.columnToLetter((int)2));
        Assert.assertEquals((Object)"AA", (Object)GoogleSheetsUtils.columnToLetter((int)27));
        Assert.assertEquals((Object)"CV", (Object)GoogleSheetsUtils.columnToLetter((int)100));
        Assert.assertEquals((Object)"ZWZ", (Object)GoogleSheetsUtils.columnToLetter((int)18200));
    }

    @Test
    public void testA1toIntResolution() {
        Assert.assertEquals((long)1L, (long)GoogleSheetsUtils.letterToColumnIndex((String)"A"));
        Assert.assertEquals((long)2L, (long)GoogleSheetsUtils.letterToColumnIndex((String)"B"));
        Assert.assertEquals((long)27L, (long)GoogleSheetsUtils.letterToColumnIndex((String)"AA"));
        Assert.assertEquals((long)100L, (long)GoogleSheetsUtils.letterToColumnIndex((String)"CV"));
        Assert.assertEquals((long)18200L, (long)GoogleSheetsUtils.letterToColumnIndex((String)"ZWZ"));
    }
}

