/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.googlesheets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsStoragePlugin;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
@Ignore(value="These tests require a live Google Sheets connection.  Please run manually.")
public class TestGoogleSheetsWriter
extends ClusterTest {
    private static final String AUTH_URI = "https://accounts.google.com/o/oauth2/auth";
    private static final String TOKEN_URI = "https://oauth2.googleapis.com/token";
    private static final List<String> REDIRECT_URI = new ArrayList<String>(Arrays.asList("urn:ietf:wg:oauth:2.0:oob", "http://localhost"));
    private static StoragePluginRegistry pluginRegistry;
    private static String accessToken;
    private static String refreshToken;
    private static String sheetID;

    @BeforeClass
    public static void init() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        String oauthJson = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/tokens/oauth_tokens.json"), (Charset)Charsets.UTF_8).read();
        ObjectMapper mapper = JacksonUtils.createObjectMapper();
        Map tokenMap = (Map)mapper.readValue(oauthJson, Map.class);
        String clientID = (String)tokenMap.get("client_id");
        String clientSecret = (String)tokenMap.get("client_secret");
        accessToken = (String)tokenMap.get("access_token");
        refreshToken = (String)tokenMap.get("refresh_token");
        sheetID = (String)tokenMap.get("sheet_id");
        pluginRegistry = cluster.drillbit().getContext().getStorage();
        GoogleSheetsStoragePluginConfig config = GoogleSheetsStoragePluginConfig.builder().clientID(clientID).clientSecret(clientSecret).redirectUris(REDIRECT_URI).authUri(AUTH_URI).tokenUri(TOKEN_URI).extractHeaders(Boolean.valueOf(true)).allTextMode(Boolean.valueOf(false)).build();
        config.setEnabled(Boolean.valueOf(true));
        pluginRegistry.validatedPut("googlesheets", (StoragePluginConfig)config);
    }

    @Test
    public void testBasicCTAS() throws Exception {
        try {
            this.initializeTokens();
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String query = "CREATE TABLE googlesheets.`test_sheet`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
    }

    @Test
    public void testCTASLifecycle() throws Exception {
        try {
            this.initializeTokens();
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("CREATE TABLE googlesheets.`%s`.`Sheet3` AS SELECT * FROM cp.`data/insert_data.csvh`", sheetID);
        QueryBuilder.QuerySummary results = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)results.succeeded());
        sql = String.format("SELECT * FROM googlesheets.`%s`.`Sheet3`", sheetID);
        results = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)results.succeeded());
        Assert.assertEquals((long)2L, (long)results.recordCount());
        sql = String.format("INSERT INTO googlesheets.`%s`.`Sheet3` SELECT * FROM cp.`data/insert_data2.csvh`", sheetID);
        results = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)results.succeeded());
        sql = String.format("SELECT * FROM googlesheets.`%s`.`Sheet3`", sheetID);
        DirectRowSet rowSet = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("col1", TypeProtos.MinorType.FLOAT8).addNullable("col2", TypeProtos.MinorType.FLOAT8).addNullable("col3", TypeProtos.MinorType.FLOAT8).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1, 2, 3}).addRow(new Object[]{4, 5, 6}).addRow(new Object[]{7, 8, 9}).addRow(new Object[]{10, 11, 12}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)rowSet);
        sql = String.format("DROP TABLE googlesheets.`%s`.`Sheet3`", sheetID);
        results = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)results.succeeded());
        sql = String.format("SELECT * FROM googlesheets.`%s`.`Sheet3`", sheetID);
        try {
            results = this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("'Sheet3' not found"));
        }
    }

    private void initializeTokens() throws StoragePluginRegistry.PluginException {
        GoogleSheetsStoragePlugin plugin = (GoogleSheetsStoragePlugin)pluginRegistry.getPlugin("googlesheets");
        plugin.initializeTokenTableForTesting();
        PersistentTokenTable tokenTable = plugin.getTokenTable();
        tokenTable.setAccessToken(accessToken);
        tokenTable.setRefreshToken(refreshToken);
        tokenTable.setExpiresIn("50000");
    }
}

