/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.googlesheets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsStoragePlugin;
import org.apache.drill.exec.store.googlesheets.GoogleSheetsStoragePluginConfig;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="This test requires a live connection to Google Sheets.  Please run tests manually.")
public class TestGoogleSheetsLimitPushdown
extends ClusterTest {
    private static final String AUTH_URI = "https://accounts.google.com/o/oauth2/auth";
    private static final String TOKEN_URI = "https://oauth2.googleapis.com/token";
    private static final List<String> REDIRECT_URI = new ArrayList<String>(Arrays.asList("urn:ietf:wg:oauth:2.0:oob", "http://localhost"));
    private static StoragePluginRegistry pluginRegistry;
    private static String accessToken;
    private static String refreshToken;
    private static String sheetID;

    @BeforeClass
    public static void init() throws Exception {
        String oauthJson = Files.asCharSource((File)DrillFileUtils.getResourceAsFile((String)"/tokens/oauth_tokens.json"), (Charset)Charsets.UTF_8).read();
        ObjectMapper mapper = JacksonUtils.createObjectMapper();
        Map tokenMap = (Map)mapper.readValue(oauthJson, Map.class);
        String clientID = (String)tokenMap.get("client_id");
        String clientSecret = (String)tokenMap.get("client_secret");
        accessToken = (String)tokenMap.get("access_token");
        refreshToken = (String)tokenMap.get("refresh_token");
        sheetID = (String)tokenMap.get("sheet_id");
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true);
        TestGoogleSheetsLimitPushdown.startCluster((ClusterFixtureBuilder)builder);
        int portNumber = cluster.drillbit().getWebServerPort();
        pluginRegistry = cluster.drillbit().getContext().getStorage();
        GoogleSheetsStoragePluginConfig config = GoogleSheetsStoragePluginConfig.builder().clientID(clientID).clientSecret(clientSecret).redirectUris(REDIRECT_URI).authUri(AUTH_URI).tokenUri(TOKEN_URI).allTextMode(Boolean.valueOf(false)).extractHeaders(Boolean.valueOf(true)).build();
        config.setEnabled(Boolean.valueOf(true));
        pluginRegistry.validatedPut("googlesheets", (StoragePluginConfig)config);
    }

    @Test
    public void testLimit() throws Exception {
        try {
            this.initializeTokens();
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM googlesheets.`%s`.`MixedSheet` LIMIT 5", sheetID);
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=5"}).match();
    }

    @Test
    public void testLimitWithOrderBy() throws Exception {
        try {
            this.initializeTokens();
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM googlesheets.`%s`.`MixedSheet` ORDER BY Col2 LIMIT 4", sheetID);
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=-1"}).match();
    }

    @Test
    public void testLimitWithOffset() throws Exception {
        try {
            this.initializeTokens();
        }
        catch (StoragePluginRegistry.PluginException e) {
            Assert.fail((String)e.getMessage());
        }
        String sql = String.format("SELECT * FROM googlesheets.`%s`.`MixedSheet` LIMIT 4 OFFSET 5", sheetID);
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=9"}).match();
    }

    private void initializeTokens() throws StoragePluginRegistry.PluginException {
        GoogleSheetsStoragePlugin plugin = (GoogleSheetsStoragePlugin)pluginRegistry.getPlugin("googlesheets");
        plugin.initializeTokenTableForTesting();
        PersistentTokenTable tokenTable = plugin.getTokenTable();
        tokenTable.setAccessToken(accessToken);
        tokenTable.setRefreshToken(refreshToken);
        tokenTable.setExpiresIn("50000");
    }
}

