/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.googlesheets;

import org.apache.drill.exec.store.googlesheets.utils.GoogleSheetsRangeBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestRangeBuilder {
    @Test
    public void testBasicRange() {
        GoogleSheetsRangeBuilder rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 10000);
        Assert.assertEquals((Object)"'Sheet1'!1:10000", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!10001:20000", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!20001:30000", (Object)rangeBuilder.next());
        rangeBuilder.lastBatch();
        Assert.assertNull((Object)rangeBuilder.next());
    }

    @Test
    public void testRangeWithLimit() {
        GoogleSheetsRangeBuilder rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 100).addLimit(204);
        Assert.assertEquals((Object)"'Sheet1'!1:100", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!101:200", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!201:204", (Object)rangeBuilder.next());
        Assert.assertNull((Object)rangeBuilder.next());
    }

    @Test
    public void testRangeWithColumnsAndRowCount() {
        GoogleSheetsRangeBuilder rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 10);
        rangeBuilder.addFirstColumn("A").addLastColumn("F").isStarQuery(true).addRowCount(25);
        Assert.assertEquals((Object)"'Sheet1'!A1:F10", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!A11:F20", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!A21:F25", (Object)rangeBuilder.next());
        Assert.assertNull((Object)rangeBuilder.next());
    }

    @Test
    public void testRangeWithColumnsAndLimitAndRowCount() {
        GoogleSheetsRangeBuilder rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 100);
        rangeBuilder.addFirstColumn("A").addLastColumn("F").isStarQuery(true).addRowCount(25);
        Assert.assertEquals((Object)"'Sheet1'!A1:F25", (Object)rangeBuilder.next());
        Assert.assertNull((Object)rangeBuilder.next());
        rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 100);
        rangeBuilder.addFirstColumn("A").addLastColumn("F").isStarQuery(true).addRowCount(25).addLimit(17);
        Assert.assertEquals((Object)"'Sheet1'!A1:F17", (Object)rangeBuilder.next());
        Assert.assertNull((Object)rangeBuilder.next());
        rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 100);
        rangeBuilder.addFirstColumn("A").addLastColumn("F").isStarQuery(true).addRowCount(150).addLimit(125);
        Assert.assertEquals((Object)"'Sheet1'!A1:F100", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!A101:F125", (Object)rangeBuilder.next());
        Assert.assertNull((Object)rangeBuilder.next());
        rangeBuilder = new GoogleSheetsRangeBuilder("Sheet1", 100);
        rangeBuilder.addFirstColumn("A").addLastColumn("F").isStarQuery(true).addRowCount(125).addLimit(150);
        Assert.assertEquals((Object)"'Sheet1'!A1:F100", (Object)rangeBuilder.next());
        Assert.assertEquals((Object)"'Sheet1'!A101:F125", (Object)rangeBuilder.next());
        Assert.assertNull((Object)rangeBuilder.next());
    }
}

