/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

@JsonTypeName(value="elastic")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ElasticsearchStorageConfig
extends StoragePluginConfig {
    public static final String NAME = "elastic";
    private static final ObjectWriter OBJECT_WRITER = JacksonUtils.createObjectMapper().writerFor(List.class);
    private static final String HOSTS = "hosts";
    private static final String PATH_PREFIX = "pathPrefix";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    public static final String CREDENTIALS_PROVIDER = "credentialsProvider";
    private static final String DISABLE_SSL_VERIFICATION = "disableSSLVerification";
    private static final String EMPTY_STRING = "";
    private final boolean disableSSLVerification;
    private final List<String> hosts;
    private final String pathPrefix;

    @JsonCreator
    public ElasticsearchStorageConfig(@JsonProperty(value="hosts") List<String> hosts, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="pathPrefix") String pathPrefix, @JsonProperty(value="authMode") String authMode, @JsonProperty(value="disableSSLVerification") boolean disableSSLVerification, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null, StoragePluginConfig.AuthMode.parseOrDefault((String)authMode, (StoragePluginConfig.AuthMode)StoragePluginConfig.AuthMode.SHARED_USER));
        this.hosts = hosts;
        this.pathPrefix = pathPrefix;
        this.disableSSLVerification = disableSSLVerification;
    }

    private ElasticsearchStorageConfig(ElasticsearchStorageConfig that, CredentialsProvider credentialsProvider) {
        super(ElasticsearchStorageConfig.getCredentialsProvider(credentialsProvider), credentialsProvider == null, that.authMode);
        this.hosts = that.hosts;
        this.pathPrefix = that.pathPrefix;
        this.disableSSLVerification = that.disableSSLVerification;
    }

    public ElasticsearchStorageConfig updateCredentialProvider(CredentialsProvider credentialsProvider) {
        return new ElasticsearchStorageConfig(this, credentialsProvider);
    }

    @JsonProperty(value="hosts")
    public List<String> getHosts() {
        return this.hosts;
    }

    @JsonProperty(value="pathPrefix")
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @JsonProperty(value="disableSSLVerification")
    public boolean getDisableSSLVerification() {
        return this.disableSSLVerification;
    }

    private static CredentialsProvider getCredentialsProvider(CredentialsProvider credentialsProvider) {
        return credentialsProvider != null ? credentialsProvider : PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER;
    }

    @JsonIgnore
    public Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).build();
    }

    @JsonIgnore
    public Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials(String username) {
        return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).setQueryUser(username).build();
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap() throws JsonProcessingException {
        HashMap credentials = new HashMap(this.credentialsProvider.getCredentials());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)HOSTS, (Object)OBJECT_WRITER.writeValueAsString(this.hosts));
        builder.put((Object)PATH_PREFIX, (Object)(this.pathPrefix != null ? this.pathPrefix : EMPTY_STRING));
        builder.put((Object)USERNAME, (Object)credentials.getOrDefault(USERNAME, EMPTY_STRING));
        builder.put((Object)PASSWORD, (Object)credentials.getOrDefault(PASSWORD, EMPTY_STRING));
        builder.put((Object)DISABLE_SSL_VERIFICATION, (Object)Boolean.valueOf(this.disableSSLVerification).toString());
        credentials.remove(USERNAME);
        credentials.remove(PASSWORD);
        builder.putAll(credentials);
        return builder.build();
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap(String queryUser) throws JsonProcessingException {
        HashMap credentials = new HashMap(this.credentialsProvider.getUserCredentials(queryUser));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)HOSTS, (Object)OBJECT_WRITER.writeValueAsString(this.hosts));
        builder.put((Object)PATH_PREFIX, (Object)(this.pathPrefix != null ? this.pathPrefix : EMPTY_STRING));
        builder.put((Object)USERNAME, (Object)credentials.getOrDefault(USERNAME, EMPTY_STRING));
        builder.put((Object)PASSWORD, (Object)credentials.getOrDefault(PASSWORD, EMPTY_STRING));
        builder.put((Object)DISABLE_SSL_VERIFICATION, (Object)Boolean.valueOf(this.disableSSLVerification).toString());
        credentials.remove(USERNAME);
        credentials.remove(PASSWORD);
        builder.putAll(credentials);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchStorageConfig that = (ElasticsearchStorageConfig)((Object)o);
        return Objects.equals(this.hosts, that.hosts) && Objects.equals(this.pathPrefix, that.pathPrefix) && Objects.equals(this.credentialsProvider, that.credentialsProvider) && Objects.equals(this.disableSSLVerification, that.disableSSLVerification);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.pathPrefix, this.disableSSLVerification, this.credentialsProvider);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field(HOSTS, this.hosts).field(PATH_PREFIX, this.pathPrefix).field(DISABLE_SSL_VERIFICATION, (Object)this.disableSSLVerification).field(CREDENTIALS_PROVIDER, (Object)this.credentialsProvider).toString();
    }
}

