/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.util.ObjectBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.json.simple.JSONObject;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElasticSearchPlanTest
extends ClusterTest {
    private static ElasticsearchClient elasticsearchClient;
    private static final List<String> indexNames;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ElasticSearchPlanTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), "elastic", "s3cret", null, StoragePluginConfig.AuthMode.SHARED_USER.name(), true, null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        elasticsearchClient = TestElasticsearchSuite.getESClient();
        ElasticSearchPlanTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().delete(deleteIndexRequest);
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        indexNames.add("nation");
        CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index("nation").build();
        elasticsearchClient.indices().create(createIndexRequest);
        StringReader input1 = new StringReader(JSONObject.toJSONString((Map)ImmutableMap.of((Object)"n_nationkey", (Object)0, (Object)"n_name", (Object)"ALGERIA", (Object)"n_regionkey", (Object)1)));
        IndexRequest request = IndexRequest.of(i -> (ObjectBuilder)i.index("nation").withJson(input1));
        elasticsearchClient.index(request);
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().refresh(refreshRequest);
    }

    @Test
    public void testProjectPushDown() throws Exception {
        this.queryBuilder().sql("select n_name, n_nationkey from elastic.`nation`").planMatcher().include(new String[]{"ElasticsearchProject.*n_name.*n_nationkey"}).exclude(new String[]{"\\*\\*"}).match();
    }

    @Test
    public void testFilterPushDown() throws Exception {
        this.queryBuilder().sql("select n_name, n_nationkey from elastic.`nation` where n_nationkey = 0").planMatcher().include(new String[]{"ElasticsearchFilter"}).match();
    }

    @Test
    public void testFilterPushDownWithJoin() throws Exception {
        String query = "select * from elastic.`nation` e\njoin elastic.`nation` s on e.n_nationkey = s.n_nationkey where e.n_name = 'algeria'";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"ElasticsearchFilter"}).match();
    }

    @Test
    public void testAggregationPushDown() throws Exception {
        this.queryBuilder().sql("select count(*) from elastic.`nation`").planMatcher().include(new String[]{"ElasticsearchAggregate.*COUNT"}).match();
    }

    @Test
    public void testLimitWithSortPushDown() throws Exception {
        this.queryBuilder().sql("select n_nationkey from elastic.`nation` order by n_name limit 3").planMatcher().include(new String[]{"ElasticsearchSort.*sort.*fetch"}).match();
    }

    @Test
    public void testAggregationWithGroupByPushDown() throws Exception {
        this.queryBuilder().sql("select sum(n_nationkey) from elastic.`nation` group by n_regionkey").planMatcher().include(new String[]{"ElasticsearchAggregate.*SUM"}).match();
    }

    static {
        indexNames = new LinkedList<String>();
    }
}

