/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.util.ObjectBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.TestBuilder;
import org.json.simple.JSONObject;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticComplexTypesTest
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(ElasticComplexTypesTest.class);
    private static final List<String> indexNames = new LinkedList<String>();
    private static ElasticsearchClient elasticsearchClient;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ElasticComplexTypesTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), "elastic", "s3cret", null, StoragePluginConfig.AuthMode.SHARED_USER.name(), false, null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        elasticsearchClient = TestElasticsearchSuite.getESClient();
        ElasticComplexTypesTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().delete(deleteIndexRequest);
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        indexNames.add("arr");
        CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index("arr").build();
        elasticsearchClient.indices().create(createIndexRequest);
        StringReader input1 = new StringReader(JSONObject.toJSONString((Map)ImmutableMap.of((Object)"string_arr", Arrays.asList("a", "b", "c", "d"), (Object)"int_arr", Arrays.asList(1, 2, 3, 4, 0), (Object)"nest_int_arr", Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4, 0)))));
        IndexRequest request = IndexRequest.of(i -> (ObjectBuilder)i.index("arr").withJson(input1));
        logger.debug("Insert response {}", (Object)elasticsearchClient.index(request));
        indexNames.add("map");
        createIndexRequest = new CreateIndexRequest.Builder().index("map").build();
        elasticsearchClient.indices().create(createIndexRequest);
        ImmutableMap map = ImmutableMap.of((Object)"a", (Object)123, (Object)"b", (Object)"abc");
        ImmutableMap nested_map = ImmutableMap.of((Object)"a", (Object)123, (Object)"b", (Object)ImmutableMap.of((Object)"c", (Object)"abc"));
        StringReader input12 = new StringReader(JSONObject.toJSONString((Map)ImmutableMap.of((Object)"prim_field", (Object)321, (Object)"nest_field", (Object)map, (Object)"more_nest_field", (Object)nested_map, (Object)"map_arr", Collections.singletonList(nested_map))));
        IndexRequest request2 = IndexRequest.of(i -> (ObjectBuilder)i.index("map").withJson(input12));
        logger.debug("Insert response {}", (Object)elasticsearchClient.index(request2));
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().refresh(refreshRequest);
        logger.debug("Data preparation complete.");
    }

    @Test
    public void testSelectStarWithArray() throws Exception {
        this.testBuilder().sqlQuery("select * from elastic.arr").unOrdered().baselineColumns(new String[]{"string_arr", "int_arr", "nest_int_arr"}).baselineValues(new Object[]{TestBuilder.listOf((Object[])new Object[]{"a", "b", "c", "d"}), TestBuilder.listOf((Object[])new Object[]{1, 2, 3, 4, 0}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.listOf((Object[])new Object[]{1, 2}), TestBuilder.listOf((Object[])new Object[]{3, 4, 0})})}).go();
    }

    @Test
    public void testSelectArrayElem() throws Exception {
        this.testBuilder().sqlQuery("select string_arr[0] c1, int_arr[1] c2, nest_int_arr[0][1] c3 from elastic.arr").unOrdered().baselineColumns(new String[]{"c1", "c2", "c3"}).baselineValues(new Object[]{"a", 2, 2}).go();
    }

    @Test
    public void testSelectStarWithJson() throws Exception {
        this.testBuilder().sqlQuery("select * from elastic.map").unOrdered().baselineColumns(new String[]{"prim_field", "nest_field", "more_nest_field", "map_arr"}).baselineValues(new Object[]{321, TestBuilder.mapOf((Object[])new Object[]{"a", 123, "b", "abc"}), TestBuilder.mapOf((Object[])new Object[]{"a", 123, "b", TestBuilder.mapOf((Object[])new Object[]{"c", "abc"})}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.mapOf((Object[])new Object[]{"a", 123, "b", TestBuilder.mapOf((Object[])new Object[]{"c", "abc"})})})}).go();
    }

    @Test
    public void testSelectNestedFields() throws Exception {
        this.testBuilder().sqlQuery("select m.nest_field.a a, m.nest_field.b b, m.more_nest_field.b.c c, map_arr[0].b.c d from elastic.map m").unOrdered().baselineColumns(new String[]{"a", "b", "c", "d"}).baselineValues(new Object[]{123, "abc", "abc", "abc"}).go();
    }
}

