/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.ClientFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.json.simple.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchUserTranslationTest
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchUserTranslationTest.class);
    private static final List<String> indexNames = new LinkedList<String>();
    private static ElasticsearchClient elasticsearchClient;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true);
        ElasticSearchUserTranslationTest.startCluster((ClusterFixtureBuilder)builder);
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(new HashMap());
        credentialsProvider.setUserCredentials("elastic", "s3cret", "testUser1");
        credentialsProvider.setUserCredentials("nope", "no way dude", "testUser2");
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), "elastic", "s3cret", null, StoragePluginConfig.AuthMode.SHARED_USER.name(), false, null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        ElasticsearchStorageConfig ut_config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), null, null, null, StoragePluginConfig.AuthMode.USER_TRANSLATION.name(), false, (CredentialsProvider)credentialsProvider);
        ut_config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("ut_elastic", (StoragePluginConfig)ut_config);
        elasticsearchClient = TestElasticsearchSuite.getESClient();
        ElasticSearchUserTranslationTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().delete(deleteIndexRequest);
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        String indexName = "t1";
        indexNames.add(indexName);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index(indexName).build();
        elasticsearchClient.indices().create(createIndexRequest);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("string_field", "a");
        map.put("int_field", 123);
        JSONObject jsonObject = new JSONObject(map);
        StringReader input = new StringReader(jsonObject.toJSONString());
        IndexRequest request = IndexRequest.of(i -> (ObjectBuilder)i.index("t1").withJson(input));
        IndexResponse response = elasticsearchClient.index(request);
        logger.debug("Insert response: {}", (Object)response.toString());
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().refresh(refreshRequest);
        indexName = "t2";
        indexNames.add(indexName);
        createIndexRequest = new CreateIndexRequest.Builder().index(indexName).build();
        elasticsearchClient.indices().create(createIndexRequest);
        map = new HashMap();
        map.put("another_int_field", 321);
        map.put("another_string_field", "b");
        jsonObject = new JSONObject(map);
        StringReader input2 = new StringReader(jsonObject.toJSONString());
        request = IndexRequest.of(i -> (ObjectBuilder)i.index("t2").withJson(input2));
        response = elasticsearchClient.index(request);
        logger.debug("Insert response: {}", (Object)response.toString());
        refreshRequest = new RefreshRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().refresh(refreshRequest);
        logger.debug("Data preparation complete.");
    }

    @Test
    public void testInfoSchemaQueryWithMissingCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"admin").property("password", (Object)"adminUserPw").build();
        String sql = "SHOW DATABASES WHERE schema_name LIKE '%elastic%'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        results.print();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testInfoSchemaQueryWithValidCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        String sql = "SHOW DATABASES WHERE schema_name LIKE '%elastic%'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testQueryWithUserTranslation() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        String sql = "select * from ut_elastic.t1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testQueryWithUserTranslationAndInvalidCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"admin").property("password", (Object)"adminUserPw").build();
        String sql = "select * from ut_elastic.t1";
        try {
            client.queryBuilder().sql(sql).rowSet();
            Assertions.fail();
        }
        catch (UserRemoteException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object 'ut_elastic' not found"));
        }
    }
}

