/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.util.ObjectBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.json.simple.JSONObject;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElasticInfoSchemaTest
extends ClusterTest {
    private static final List<String> indexNames = new LinkedList<String>();
    private static ElasticsearchClient elasticsearchClient;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ElasticInfoSchemaTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), "elastic", "s3cret", null, StoragePluginConfig.AuthMode.SHARED_USER.name(), false, null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        elasticsearchClient = TestElasticsearchSuite.getESClient();
        ElasticInfoSchemaTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().delete(deleteIndexRequest);
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        indexNames.add("t1");
        CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index("t1").build();
        elasticsearchClient.indices().create(createIndexRequest);
        StringReader input1 = new StringReader(JSONObject.toJSONString((Map)ImmutableMap.of((Object)"string_field", (Object)"a", (Object)"int_field", (Object)123)));
        IndexRequest request = IndexRequest.of(i -> (ObjectBuilder)i.index("t1").withJson(input1));
        elasticsearchClient.index(request);
        indexNames.add("t2");
        createIndexRequest = new CreateIndexRequest.Builder().index("t2").build();
        elasticsearchClient.indices().create(createIndexRequest);
        StringReader input2 = new StringReader(JSONObject.toJSONString((Map)ImmutableMap.of((Object)"another_string_field", (Object)"b", (Object)"another_int_field", (Object)321)));
        request = IndexRequest.of(i -> (ObjectBuilder)i.index("t2").withJson(input2));
        elasticsearchClient.index(request);
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(indexNames).build();
        elasticsearchClient.indices().refresh(refreshRequest);
    }

    @Test
    public void testShowTables() throws Exception {
        this.testBuilder().sqlQuery("show tables in elastic").unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"elastic", "t1"}).baselineValues(new Object[]{"elastic", "t2"}).go();
    }

    @Test
    public void testShowTablesLike() throws Exception {
        this.testBuilder().sqlQuery("show tables in elastic like '%2%'").unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"elastic", "t2"}).go();
    }
}

