/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.google.api.client.util.SslUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.elasticsearch.ElasticComplexTypesTest;
import org.apache.drill.exec.store.elasticsearch.ElasticInfoSchemaTest;
import org.apache.drill.exec.store.elasticsearch.ElasticSearchPlanTest;
import org.apache.drill.exec.store.elasticsearch.ElasticSearchQueryTest;
import org.apache.drill.exec.store.elasticsearch.ElasticSearchUserTranslationTest;
import org.apache.drill.test.BaseTest;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

@Category(value={SlowTest.class})
@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={ElasticComplexTypesTest.class, ElasticInfoSchemaTest.class, ElasticSearchPlanTest.class, ElasticSearchQueryTest.class, ElasticSearchUserTranslationTest.class})
public class TestElasticsearchSuite
extends BaseTest {
    protected static ElasticsearchContainer elasticsearch;
    public static final String ELASTICSEARCH_USERNAME = "elastic";
    public static final String ELASTICSEARCH_PASSWORD = "s3cret";
    private static final String IMAGE_NAME = "docker.elastic.co/elasticsearch/elasticsearch:8.9.1";
    private static final AtomicInteger initCount;
    private static volatile boolean runningSuite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initElasticsearch() throws IOException, GeneralSecurityException {
        Class<TestElasticsearchSuite> clazz = TestElasticsearchSuite.class;
        synchronized (TestElasticsearchSuite.class) {
            if (initCount.get() == 0) {
                TestElasticsearchSuite.startElasticsearch();
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() {
        Class<TestElasticsearchSuite> clazz = TestElasticsearchSuite.class;
        synchronized (TestElasticsearchSuite.class) {
            if (initCount.decrementAndGet() == 0 && elasticsearch != null) {
                elasticsearch.stop();
                elasticsearch.close();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }

    public static CredentialsProvider getCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ELASTICSEARCH_USERNAME, ELASTICSEARCH_PASSWORD));
        return credentialsProvider;
    }

    public static byte[] getCertAsBytes(ElasticsearchContainer container) {
        return (byte[])container.copyFileFromContainer("/usr/share/elasticsearch/config/certs/http_ca.crt", IOUtils::toByteArray);
    }

    public static SSLContext createContextFromCaCert(byte[] certAsBytes) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate trustedCa = factory.generateCertificate(new ByteArrayInputStream(certAsBytes));
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ElasticsearchClient getESClient() {
        HttpHost host = new HttpHost(elasticsearch.getHost(), elasticsearch.getMappedPort(9200).intValue(), "http");
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{host});
        builder.setHttpClientConfigCallback(clientBuilder -> {
            clientBuilder.setDefaultCredentialsProvider(TestElasticsearchSuite.getCredentialsProvider());
            return clientBuilder;
        });
        RestClientTransport transport = new RestClientTransport(builder.build(), (JsonpMapper)new JacksonJsonpMapper());
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    private static void startElasticsearch() throws GeneralSecurityException {
        elasticsearch = (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(IMAGE_NAME).withExposedPorts(new Integer[]{9200})).withStartupTimeout(Duration.ofMinutes(2L))).withStartupAttempts(5)).withPassword(ELASTICSEARCH_PASSWORD).withEnv("xpack.security.enabled", "true")).withEnv("xpack.security.transport.ssl.enabled", "false")).withEnv("discovery.type", "single-node")).withEnv("ES_JAVA_OPTS", "-Xmx2g");
        HttpsURLConnection.setDefaultSSLSocketFactory(SslUtils.trustAllSSLContext().getSocketFactory());
        elasticsearch.start();
    }

    public static String getAddress() {
        return elasticsearch.getHttpHostAddress();
    }

    static {
        initCount = new AtomicInteger(0);
        runningSuite = false;
    }
}

