/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch.plan;

import java.util.ArrayList;
import org.apache.calcite.adapter.elasticsearch.CalciteUtils;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchProject;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.store.elasticsearch.plan.NodeTypeFinder;

public class ElasticsearchProjectRule
extends ConverterRule {
    private final Convention out = ElasticsearchRel.CONVENTION;
    public static final ElasticsearchProjectRule INSTANCE = new ElasticsearchProjectRule();

    private ElasticsearchProjectRule() {
        super(Project.class, (RelTrait)Convention.NONE, (RelTrait)ElasticsearchRel.CONVENTION, "DrillElasticsearchProjectRule");
    }

    public RelNode convert(RelNode relNode) {
        Project project = (Project)relNode;
        NodeTypeFinder projectFinder = new NodeTypeFinder(ElasticsearchProject.class);
        project.getInput().accept((RelShuttle)projectFinder);
        if (projectFinder.containsNode) {
            return null;
        }
        RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
        ArrayList<RexInputRef> innerProjections = new ArrayList<RexInputRef>();
        RelDataType rowType = project.getInput().getRowType();
        DrillRelOptUtil.InputRefVisitor collectRefs = new DrillRelOptUtil.InputRefVisitor();
        project.getChildExps().forEach(exp -> exp.accept((RexVisitor)collectRefs));
        if (!collectRefs.getInputRefs().isEmpty()) {
            for (RelDataTypeField relDataTypeField : rowType.getFieldList()) {
                innerProjections.add(project.getCluster().getRexBuilder().makeInputRef(project.getInput(), relDataTypeField.getIndex()));
            }
        }
        boolean allExprsInputRefs = project.getChildExps().stream().allMatch(rexNode -> rexNode instanceof RexInputRef);
        if (collectRefs.getInputRefs().isEmpty() || allExprsInputRefs) {
            return CalciteUtils.createProject(traitSet, ElasticsearchProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }
        ElasticsearchProject elasticsearchProject = CalciteUtils.createProject(traitSet, ElasticsearchProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), innerProjections, project.getInput().getRowType());
        return project.copy(project.getTraitSet(), (RelNode)elasticsearchProject, project.getProjects(), project.getRowType());
    }
}

