/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.http.HttpHost;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElasticInfoSchemaTest
extends ClusterTest {
    private static final List<String> indexNames = new ArrayList<String>();
    public static RestHighLevelClient restHighLevelClient;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ElasticInfoSchemaTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), null, null, null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        ElasticInfoSchemaTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        for (String indexName : indexNames) {
            restHighLevelClient.indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
        }
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)TestElasticsearchSuite.getAddress())}));
        String indexName = "t1";
        indexNames.add(indexName);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("string_field", "a");
        builder.field("int_field", 123);
        builder.endObject();
        IndexRequest indexRequest = new IndexRequest(indexName).source(builder);
        restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        restHighLevelClient.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        indexName = "t2";
        indexNames.add(indexName);
        createIndexRequest = new CreateIndexRequest(indexName);
        restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("another_int_field", 321);
        builder.field("another_string_field", "b");
        builder.endObject();
        indexRequest = new IndexRequest(indexName).source(builder);
        restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        restHighLevelClient.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
    }

    @Test
    public void testShowTables() throws Exception {
        this.testBuilder().sqlQuery("show tables in elastic").unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"elastic", "t1"}).baselineValues(new Object[]{"elastic", "t2"}).go();
    }

    @Test
    public void testShowTablesLike() throws Exception {
        this.testBuilder().sqlQuery("show tables in elastic like '%2%'").unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"elastic", "t2"}).go();
    }
}

