/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.elasticsearch.ElasticComplexTypesTest;
import org.apache.drill.exec.store.elasticsearch.ElasticInfoSchemaTest;
import org.apache.drill.exec.store.elasticsearch.ElasticSearchPlanTest;
import org.apache.drill.exec.store.elasticsearch.ElasticSearchQueryTest;
import org.apache.drill.test.BaseTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

@Category(value={SlowTest.class})
@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={ElasticComplexTypesTest.class, ElasticInfoSchemaTest.class, ElasticSearchPlanTest.class, ElasticSearchQueryTest.class})
public class TestElasticsearchSuite
extends BaseTest {
    protected static ElasticsearchContainer elasticsearch;
    private static final AtomicInteger initCount;
    private static volatile boolean runningSuite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initElasticsearch() {
        Class<TestElasticsearchSuite> clazz = TestElasticsearchSuite.class;
        synchronized (TestElasticsearchSuite.class) {
            if (initCount.get() == 0) {
                TestElasticsearchSuite.startElasticsearch();
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() {
        Class<TestElasticsearchSuite> clazz = TestElasticsearchSuite.class;
        synchronized (TestElasticsearchSuite.class) {
            if (initCount.decrementAndGet() == 0 && elasticsearch != null) {
                elasticsearch.stop();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void startElasticsearch() {
        DockerImageName imageName = DockerImageName.parse((String)"elasticsearch:7.14.2").asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch");
        elasticsearch = (ElasticsearchContainer)new ElasticsearchContainer(imageName).withStartupTimeout(Duration.ofMinutes(2L));
        elasticsearch.start();
    }

    public static String getAddress() {
        return elasticsearch.getHttpHostAddress();
    }

    static {
        initCount = new AtomicInteger(0);
        runningSuite = false;
    }
}

