/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import java.io.IOException;
import java.util.Collections;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.http.HttpHost;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElasticSearchPlanTest
extends ClusterTest {
    public static RestHighLevelClient restHighLevelClient;
    private static String indexName;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ElasticSearchPlanTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), null, null, null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        ElasticSearchPlanTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        restHighLevelClient.indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)TestElasticsearchSuite.getAddress())}));
        indexName = "nation";
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("n_nationkey", 0);
        builder.field("n_name", "ALGERIA");
        builder.field("n_regionkey", 1);
        builder.endObject();
        IndexRequest indexRequest = new IndexRequest(indexName).source(builder);
        restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        restHighLevelClient.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
    }

    @Test
    public void testProjectPushDown() throws Exception {
        this.queryBuilder().sql("select n_name, n_nationkey from elastic.`nation`").planMatcher().include(new String[]{"ElasticsearchProject.*n_name.*n_nationkey"}).exclude(new String[]{"\\*\\*"}).match();
    }

    @Test
    public void testFilterPushDown() throws Exception {
        this.queryBuilder().sql("select n_name, n_nationkey from elastic.`nation` where n_nationkey = 0").planMatcher().include(new String[]{"ElasticsearchFilter"}).match();
    }

    @Test
    public void testFilterPushDownWithJoin() throws Exception {
        String query = "select * from elastic.`nation` e\njoin elastic.`nation` s on e.n_nationkey = s.n_nationkey where e.n_name = 'algeria'";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"ElasticsearchFilter"}).match();
    }

    @Test
    public void testAggregationPushDown() throws Exception {
        this.queryBuilder().sql("select count(*) from elastic.`nation`").planMatcher().include(new String[]{"ElasticsearchAggregate.*COUNT"}).match();
    }

    @Test
    public void testLimitWithSortPushDown() throws Exception {
        this.queryBuilder().sql("select n_nationkey from elastic.`nation` order by n_name limit 3").planMatcher().include(new String[]{"ElasticsearchSort.*sort.*fetch"}).match();
    }

    @Test
    public void testAggregationWithGroupByPushDown() throws Exception {
        this.queryBuilder().sql("select sum(n_nationkey) from elastic.`nation` group by n_regionkey").planMatcher().include(new String[]{"ElasticsearchAggregate.*SUM"}).match();
    }
}

