/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.TestElasticsearchSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.TestBuilder;
import org.apache.http.HttpHost;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElasticComplexTypesTest
extends ClusterTest {
    private static final List<String> indexNames = new ArrayList<String>();
    public static RestHighLevelClient restHighLevelClient;

    @BeforeClass
    public static void init() throws Exception {
        TestElasticsearchSuite.initElasticsearch();
        ElasticComplexTypesTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        ElasticsearchStorageConfig config = new ElasticsearchStorageConfig(Collections.singletonList(TestElasticsearchSuite.getAddress()), null, null, null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("elastic", (StoragePluginConfig)config);
        ElasticComplexTypesTest.prepareData();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        for (String indexName : indexNames) {
            restHighLevelClient.indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
        }
        TestElasticsearchSuite.tearDownCluster();
    }

    private static void prepareData() throws IOException {
        restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)TestElasticsearchSuite.elasticsearch.getHttpHostAddress())}));
        String indexName = "arr";
        indexNames.add(indexName);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("string_arr", Arrays.asList("a", "b", "c", "d"));
        builder.field("int_arr", Arrays.asList(1, 2, 3, 4, 0));
        builder.field("nest_int_arr", Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4, 0)));
        builder.endObject();
        IndexRequest indexRequest = new IndexRequest(indexName).source(builder);
        restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        restHighLevelClient.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        indexName = "map";
        indexNames.add(indexName);
        createIndexRequest = new CreateIndexRequest(indexName);
        restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("prim_field", 321);
        builder.field("nest_field", (Map)ImmutableMap.of((Object)"a", (Object)123, (Object)"b", (Object)"abc"));
        builder.field("more_nest_field", (Map)ImmutableMap.of((Object)"a", (Object)123, (Object)"b", (Object)ImmutableMap.of((Object)"c", (Object)"abc")));
        builder.field("map_arr", Collections.singletonList(ImmutableMap.of((Object)"a", (Object)123, (Object)"b", (Object)ImmutableMap.of((Object)"c", (Object)"abc"))));
        builder.endObject();
        indexRequest = new IndexRequest(indexName).source(builder);
        restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        restHighLevelClient.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
    }

    @Test
    public void testSelectStarWithArray() throws Exception {
        this.testBuilder().sqlQuery("select * from elastic.arr").unOrdered().baselineColumns(new String[]{"string_arr", "int_arr", "nest_int_arr"}).baselineValues(new Object[]{TestBuilder.listOf((Object[])new Object[]{"a", "b", "c", "d"}), TestBuilder.listOf((Object[])new Object[]{1, 2, 3, 4, 0}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.listOf((Object[])new Object[]{1, 2}), TestBuilder.listOf((Object[])new Object[]{3, 4, 0})})}).go();
    }

    @Test
    public void testSelectArrayElem() throws Exception {
        this.testBuilder().sqlQuery("select string_arr[0] c1, int_arr[1] c2, nest_int_arr[0][1] c3 from elastic.arr").unOrdered().baselineColumns(new String[]{"c1", "c2", "c3"}).baselineValues(new Object[]{"a", 2, 2}).go();
    }

    @Test
    public void testSelectStarWithJson() throws Exception {
        this.testBuilder().sqlQuery("select * from elastic.map").unOrdered().baselineColumns(new String[]{"prim_field", "nest_field", "more_nest_field", "map_arr"}).baselineValues(new Object[]{321, TestBuilder.mapOf((Object[])new Object[]{"a", 123, "b", "abc"}), TestBuilder.mapOf((Object[])new Object[]{"a", 123, "b", TestBuilder.mapOf((Object[])new Object[]{"c", "abc"})}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.mapOf((Object[])new Object[]{"a", 123, "b", TestBuilder.mapOf((Object[])new Object[]{"c", "abc"})})})}).go();
    }

    @Test
    public void testSelectNestedFields() throws Exception {
        this.testBuilder().sqlQuery("select m.nest_field.a a, m.nest_field.b b, m.more_nest_field.b.c c, map_arr[0].b.c d from elastic.map m").unOrdered().baselineColumns(new String[]{"a", "b", "c", "d"}).baselineValues(new Object[]{123, "abc", "abc", "abc"}).go();
    }
}

